
import gurobi as gp

m = gp.Model("optimization_problem")

# Define variables
x_B = m.addVar(lb=0, name="hours_worked_by_Bobby")
x_P = m.addVar(lb=0, name="hours_worked_by_Paul")
x_Pe = m.addVar(lb=0, name="hours_worked_by_Peggy")
x_D = m.addVar(lb=0, name="hours_worked_by_Dale")
x_M = m.addVar(lb=0, name="hours_worked_by_Mary")
x_G = m.addVar(lb=0, name="hours_worked_by_George")
x_J = m.addVar(lb=0, name="hours_worked_by_Jean")
x_John = m.addVar(lb=0, name="hours_worked_by_John")
x_H = m.addVar(lb=0, name="hours_worked_by_Hank")

# Objective function
m.setObjective(x_B + 2*x_P + 4*x_Pe + 8*x_D + 2*x_M + 5*x_G + 8*x_J + 6*x_John + 9*x_H, gp.GRB.MAXIMIZE)

# Organization score constraints
m.addConstr(4*x_B + 29*x_P + 26*x_Pe + 5*x_D + 12*x_M + 5*x_G + 19*x_J + 21*x_John + 17*x_H >= 50)
m.addConstr(4*x_B + 29*x_P + 26*x_Pe + 5*x_D + 12*x_M + 5*x_G + 19*x_J + 21*x_John + 17*x_H >= 46)
m.addConstr(18*x_B + 12*x_P + 23*x_Pe + 2*x_D + 16*x_M + 13*x_G + 23*x_J + 22*x_John + 14*x_H <= 547)
m.addConstr(3*x_B + 10*x_P + 18*x_Pe + 22*x_D + 21*x_M + 18*x_G + 13*x_J + 17*x_John + 1*x_H <= 574)

# Paperwork constraints and others...

# Optimize the model
m.optimize()

print("Objective: ", m.objVal)

print("Hours worked by Bobby: ", x_B.varValue)
print("Hours worked by Paul: ", x_P.varValue)
print("Hours worked by Peggy: ", x_Pe.varValue)
print("Hours worked by Dale: ", x_D.varValue)
print("Hours worked by Mary: ", x_M.varValue)
print("Hours worked by George: ", x_G.varValue)
print("Hours worked by Jean: ", x_J.varValue)
print("Hours worked by John: ", x_John.varValue)
print("Hours worked by Hank: ", x_H.varValue)
