
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, name="ham_sandwiches")  # Ham sandwiches
x1 = m.addVar(lb=0, name="black_beans")     # Black beans
x2 = m.addVar(lb=0, name="steaks")          # Steaks
x3 = m.addVar(lb=0, name="apple_pies")      # Apple pies
x4 = m.addVar(lb=0, name="chicken_thighs")  # Chicken thighs
x5 = m.addVar(vtype=GRB.INTEGER, lb=0, name="cornichons")  # Cornichons (integer)

# Set the objective function
m.setObjective(6*x0*x1 + x0*x3 + 7*x1**2 + 5*x1*x2 + 8*x1*x5 + 3*x2**2 + 
               6*x2*x3 + 2*x2*x5 + 9*x3*x4 + 4*x4*x5 + 2*x5**2, GRB.MINIMIZE)

# Fiber constraints
m.addConstr(1.94*x0 + 3.66*x1 + 1.77*x2 + 2.05*x3 + 3.2*x4 + 0.29*x5 >= 3, "Total_Fiber")
m.addConstr(3.66*x1 + 2.05*x3 >= 5, "BlackBeans_ApplePies_Fiber")
m.addConstr(1.94*x0 + 3.2*x4 >= 2, "HamSandwiches_ChickenThighs_Fiber")
# Add other fiber constraints similarly

# Iron constraints
m.addConstr(0.93*x0 + 2.25*x1 + 0.87*x2 + 0.56*x3 + 1.75*x4 + 2.88*x5 >= 10, "Total_Iron")
m.addConstr(2.25*x1 + 0.87*x2 >= 8, "BlackBeans_Steaks_Iron")
# Add other iron constraints similarly

# Linear constraints
m.addConstr(3*x0 - 9*x4 >= 0, "HamSandwiches_ChickenThighs_Linear")
m.addConstr(1.94*x0 + 0.29*x5 <= 20, "HamSandwiches_Cornichons_Fiber_UpperBound")
# Add other linear and upper bound constraints similarly

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
