
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Likelihood to Quit Cost")

# Create variables
mary_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mary_hours")
dale_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="dale_hours")
laura_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="laura_hours")

# Set objective function
model.setObjective(8.72 * mary_hours + 5.55 * dale_hours + 1.19 * laura_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(4.77 * dale_hours + 11.23 * laura_hours >= 34, "c1")
model.addConstr(9.26 * mary_hours + 11.23 * laura_hours >= 29, "c2")
model.addConstr(9.26 * mary_hours + 4.77 * dale_hours + 11.23 * laura_hours >= 29, "c3")
model.addConstr(-4 * dale_hours + 8 * laura_hours >= 0, "c4")
model.addConstr(9.26 * mary_hours + 4.77 * dale_hours <= 43, "c5")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {model.objVal}")
    print(f"Mary's hours: {mary_hours.x}")
    print(f"Dale's hours: {dale_hours.x}")
    print(f"Laura's hours: {laura_hours.x}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

