
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the decision variables
M = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Mary")
D = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")
L = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Laura")

# Define the objective function
m.setObjective(8.72*M + 5.55*D + 1.19*L, GRB.MINIMIZE)

# Add constraints
m.addConstr(4.77*D + 11.23*L >= 34, "D_and_L_constraint")
m.addConstr(9.26*M + 11.23*L >= 29, "M_and_L_constraint")
m.addConstr(9.26*M + 4.77*D + 11.23*L >= 29, "M_D_and_L_constraint")
m.addConstr(-4*D + 8*L >= 0, "D_and_L_relationship")
m.addConstr(9.26*M + 4.77*D <= 43, "M_and_D_constraint")

# Optimize the model
m.optimize()

# Print out the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
