
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    M = model.addVar(name="hours_worked_by_Mary", lb=0)  # Lower bound is 0, assuming hours cannot be negative
    D = model.addVar(name="hours_worked_by_Dale", lb=0)
    L = model.addVar(name="hours_worked_by_Laura", lb=0)

    # Objective function
    model.setObjective(8.72 * M + 5.55 * D + 1.19 * L, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4.77 * D + 11.23 * L >= 34, name="constraint_1")
    model.addConstr(9.26 * M + 11.23 * L >= 29, name="constraint_2")
    model.addConstr(9.26 * M + 4.77 * D + 11.23 * L >= 29, name="constraint_3")
    model.addConstr(-4 * D + 8 * L >= 0, name="constraint_4")
    model.addConstr(9.26 * M + 4.77 * D <= 43, name="constraint_5")

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Mary: {M.varValue}")
        print(f"Hours worked by Dale: {D.varValue}")
        print(f"Hours worked by Laura: {L.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

optimization_problem()
