
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
h = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="honeypots", vtype=gp.GRB.INTEGER)
s = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="security_engineers", vtype=gp.GRB.INTEGER)
p = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="patches_per_day", vtype=gp.GRB.INTEGER)
b = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="Mbps_bandwidth_allocated_to_monitoring", vtype=gp.GRB.INTEGER)
sys = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="system_administrators", vtype=gp.GRB.INTEGER)
so = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="security_onions", vtype=gp.GRB.INTEGER)
d = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="deployed_decoys", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(7*h + 6*s + 7*p + 9*b*s + 6*sys + 9*so + d, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(12*h + 12*s + 21*p + 10*b + 7*sys + 4*so + 23*d <= 1179, name="cost_constraint")
m.addConstr(29*h + 7*s + 12*p + 5*b + 16*sys + 14*so + 8*d <= 1006, name="network_latency_impact")
m.addConstr(22*h + 20*s + 11*p + 26*b + 8*sys + 27*so + 24*d <= 1173, name="data_confidentiality_impact")
m.addConstr(28*h + 17*s + 11*p + 15*b + 18*sys + 2*so + 14*d <= 877, name="computational_load")

# Additional constraints
m.addConstr(21*p + 23*d >= 89, name="patches_decoys_cost")
m.addConstr(12*s + 23*d >= 155, name="security_engineers_decoys_cost")
m.addConstr(7*sys + 4*so >= 144, name="system_administrators_security_onions_cost")
m.addConstr(10*b + 4*so >= 161, name="bandwidth_security_onions_cost")
m.addConstr(10*b + 23*d >= 114, name="bandwidth_decoys_cost")
m.addConstr(12*s + 10*b >= 87, name="security_engineers_bandwidth_cost")
m.addConstr(21*p + 4*so >= 155, name="patches_security_onions_cost")
m.addConstr(h + 4*so >= 114, name="honeypots_security_onions_cost")
m.addConstr(21*p + 10*b >= 75, name="patches_bandwidth_cost")
m.addConstr(4*so + 23*d >= 114, name="security_onions_decoys_cost")
m.addConstr(7*sys + 4*so + 23*d >= 124, name="system_administrators_security_onions_decoys_cost")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Honeypots: ", h.varValue)
    print("Security Engineers: ", s.varValue)
    print("Patches per day: ", p.varValue)
    print("Mbps bandwidth allocated to monitoring: ", b.varValue)
    print("System Administrators: ", sys.varValue)
    print("Security Onions: ", so.varValue)
    print("Deployed Decoys: ", d.varValue)
else:
    print("The problem is infeasible.")
