
from gurobipy import Model, GRB, quicksum

# Create a new model
model = Model("Work Optimization")

# Create variables
bill_hours = model.addVar(name="Bill_Hours", lb=0.0)
jean_hours = model.addVar(name="Jean_Hours", lb=0.0)
john_hours = model.addVar(name="John_Hours", lb=0.0)
mary_hours = model.addVar(name="Mary_Hours", lb=0.0)

# Set objective function
model.setObjective(
    6.2 * bill_hours**2
    + 3.0 * bill_hours * jean_hours
    + 8.09 * bill_hours * mary_hours
    + 5.65 * jean_hours**2
    + 1.8 * jean_hours * john_hours
    + 7.62 * jean_hours * mary_hours
    + 3.15 * john_hours**2
    + 5.85 * john_hours * mary_hours
    + 2.68 * mary_hours**2
    + 1.05 * bill_hours
    + 3.25 * jean_hours
    + 4.97 * mary_hours,
    GRB.MAXIMIZE,
)

# Resource coefficients
resource_coeffs = {
    'r0': {'x0': 16, 'x1': 8, 'x2': 19, 'x3': 13},  # Computer competence
    'r1': {'x0': 2, 'x1': 8, 'x2': 17, 'x3': 4},  # Paperwork competence
    'r2': {'x0': 8, 'x1': 9, 'x2': 12, 'x3': 6},  # Likelihood to quit
    'r3': {'x0': 11, 'x1': 13, 'x2': 3, 'x3': 13},  # Work quality
    'r4': {'x0': 12, 'x1': 6, 'x2': 7, 'x3': 1},  # Productivity
}

variables = {'x0': bill_hours, 'x1': jean_hours, 'x2': john_hours, 'x3': mary_hours}


# Add constraints
model.addConstr(8 * jean_hours + 19 * john_hours + 13 * mary_hours >= 44, "c1")
model.addConstr(8 * bill_hours + 12 * john_hours + 6 * mary_hours >= 80, "c2")
model.addConstr(9 * jean_hours + 12 * john_hours + 6 * mary_hours >= 80, "c3")
model.addConstr(8 * bill_hours**2 + 9 * jean_hours**2 + 6 * mary_hours**2 >= 80, "c4")
model.addConstr(8 * bill_hours**2 + 12 * john_hours**2 + 6 * mary_hours**2 >= 58, "c5")
model.addConstr(9 * jean_hours + 12 * john_hours + 6 * mary_hours >= 58, "c6")
model.addConstr(8 * bill_hours + 9 * jean_hours + 6 * mary_hours >= 58, "c7")
model.addConstr(8 * bill_hours + 12 * john_hours + 6 * mary_hours >= 92, "c8")
model.addConstr(9 * jean_hours**2 + 12 * john_hours**2 + 6 * mary_hours**2 >= 92, "c9")
model.addConstr(8 * bill_hours**2 + 9 * jean_hours**2 + 6 * mary_hours**2 >= 92, "c10")
model.addConstr(13 * jean_hours + 13 * mary_hours >= 65, "c11")
model.addConstr(7 * john_hours + 1 * mary_hours >= 44, "c12")
model.addConstr(12 * bill_hours**2 + 1 * mary_hours**2 >= 59, "c13")
model.addConstr(6 * jean_hours + 7 * john_hours + 1 * mary_hours >= 52, "c14")
model.addConstr(12 * bill_hours + 6 * jean_hours + 7 * john_hours >= 52, "c15")
model.addConstr(6 * jean_hours + 7 * john_hours + 1 * mary_hours >= 70, "c16")
model.addConstr(12 * bill_hours**2 + 6 * jean_hours**2 + 7 * john_hours**2 >= 70, "c17")
model.addConstr(16 * bill_hours + 19 * john_hours <= 104, "c18")
model.addConstr(8 * jean_hours**2 + 13 * mary_hours**2 <= 118, "c19")
model.addConstr(16 * bill_hours**2 + 8 * jean_hours**2 + 13 * mary_hours**2 <= 93, "c20")
model.addConstr(8 * jean_hours + 19 * john_hours + 13 * mary_hours <= 74, "c21")
model.addConstr(16 * bill_hours + 8 * jean_hours + 19 * john_hours + 13 * mary_hours <= 74, "c22")
model.addConstr(8 * jean_hours**2 + 4 * mary_hours**2 <= 49, "c23")
model.addConstr(17 * john_hours + 4 * mary_hours <= 47, "c24")
model.addConstr(2 * bill_hours + 8 * jean_hours <= 83, "c25")
model.addConstr(2 * bill_hours + 4 * mary_hours <= 105, "c26")
model.addConstr(2 * bill_hours + 8 * jean_hours + 17 * john_hours <= 43, "c27")
model.addConstr(8 * jean_hours + 17 * john_hours + 4 * mary_hours <= 115, "c28")
model.addConstr(2 * bill_hours + 8 * jean_hours + 17 * john_hours + 4 * mary_hours <= 115, "c29")
model.addConstr(8 * bill_hours + 6 * mary_hours <= 294, "c30")
model.addConstr(9 * jean_hours + 6 * mary_hours <= 337, "c31")
model.addConstr(12 * john_hours + 6 * mary_hours <= 270, "c32")
model.addConstr(8 * bill_hours**2 + 9 * jean_hours**2 + 12 * john_hours**2 <= 334, "c33")
model.addConstr(8 * bill_hours**2 + 12 * john_hours**2 + 6 * mary_hours**2 <= 275, "c34")
model.addConstr(8 * bill_hours + 9 * jean_hours + 12 * john_hours + 6 * mary_hours <= 275, "c35")
model.addConstr(13 * jean_hours**2 + 13 * mary_hours**2 <= 151, "c36")
model.addConstr(11 * bill_hours + 3 * john_hours <= 110, "c37")
model.addConstr(11 * bill_hours**2 + 13 * jean_hours**2 <= 93, "c38")
model.addConstr(11 * bill_hours + 13 * mary_hours <= 250, "c39")
model.addConstr(11 * bill_hours + 13 * jean_hours + 13 * mary_hours <= 241, "c40")
model.addConstr(13 * jean_hours**2 + 3 * john_hours**2 + 13 * mary_hours**2 <= 90, "c41")
model.addConstr(11 * bill_hours + 3 * john_hours + 13 * mary_hours <= 195, "c42")
model.addConstr(11 * bill_hours**2 + 13 * jean_hours**2 + 3 * john_hours**2 <= 137, "c43")
model.addConstr(11 * bill_hours + 13 * jean_hours + 3 * john_hours + 13 * mary_hours <= 137, "c44")
model.addConstr(6 * jean_hours**2 + 1 * mary_hours**2 <= 259, "c45")
model.addConstr(12 * bill_hours**2 + 6 * jean_hours**2 <= 123, "c46")
model.addConstr(12 * bill_hours**2 + 1 * mary_hours**2 <= 102, "c47")
model.addConstr(12 * bill_hours**2 + 6 * jean_hours**2 + 7 * john_hours**2 <= 121, "c48")
model.addConstr(12 * bill_hours + 6 * jean_hours + 7 * john_hours + 1 * mary_hours <= 121, "c49")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bill's hours: {bill_hours.x}")
    print(f"Jean's hours: {jean_hours.x}")
    print(f"John's hours: {john_hours.x}")
    print(f"Mary's hours: {mary_hours.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

