
import gurobi as gp

# Define variables
x0 = gp.Var(name="hours_worked_by_Bill", lb=0)
x1 = gp.Var(name="hours_worked_by_Jean", lb=0)
x2 = gp.Var(name="hours_worked_by_John", lb=0)
x3 = gp.Var(name="hours_worked_by_Mary", lb=0)

# Create model
m = gp.Model()

# Objective function
m.setObjective(6.2*x0**2 + 3.0*x0*x1 + 8.09*x0*x3 + 5.65*x1**2 + 1.8*x1*x2 + 7.62*x1*x3 + 
               3.15*x2**2 + 5.85*x2*x3 + 2.68*x3**2 + 1.05*x0 + 3.25*x1 + 4.97*x3, gp.GRB.MAXIMIZE)

# Constraints
# Individual competence constraints
m.addConstr(16*x0 <= 256)
m.addConstr(2*x0 <= 122)
m.addConstr(8*x0 <= 372)
m.addConstr(11*x0 <= 284)
m.addConstr(12*x0 <= 286)

m.addConstr(8*x1 <= 256)
m.addConstr(8*x1 <= 122)
m.addConstr(9*x1 <= 372)
m.addConstr(13*x1 <= 284)
m.addConstr(6*x1 <= 286)

m.addConstr(19*x2 <= 256)
m.addConstr(17*x2 <= 122)
m.addConstr(12*x2 <= 372)
m.addConstr(3*x2 <= 284)
m.addConstr(7*x2 <= 286)

m.addConstr(13*x3 <= 256)
m.addConstr(4*x3 <= 122)
m.addConstr(6*x3 <= 372)
m.addConstr(13*x3 <= 284)
m.addConstr(1*x3 <= 286)

# Computer competence rating
m.addConstr(8*x1 + 19*x2 + 13*x3 >= 44)

# Likelihood to quit index
m.addConstr(8*x0 + 12*x2 + 6*x3 >= 80)
m.addConstr(9*x1 + 12*x2 + 6*x3 >= 80)
m.addConstr(8*x0**2 + 9*x1**2 + 6*x3**2 >= 80)
m.addConstr(8*x0**2 + 12*x2**2 + 6*x3**2 >= 58)
m.addConstr(9*x1 + 12*x2 + 6*x3 >= 58)
m.addConstr(8*x0 + 9*x1 + 6*x3 >= 58)
m.addConstr(8*x0 + 12*x2 + 6*x3 >= 92)
m.addConstr(9*x1**2 + 12*x2**2 + 6*x3**2 >= 92)
m.addConstr(8*x0**2 + 9*x1**2 + 6*x3**2 >= 92)

# Work quality rating
m.addConstr(13*x1 + 13*x3 >= 65)

# Productivity rating
m.addConstr(7*x2 + 1*x3 >= 44)
m.addConstr(12*x0**2 + 1*x3**2 >= 59)
m.addConstr(12*x0 + 6*x1 + 7*x2 >= 52)
m.addConstr(12*x0 + 6*x1 + 7*x2 + 1*x3 >= 52)
m.addConstr(12*x0 + 6*x1 + 7*x2 + 1*x3 >= 70)
m.addConstr(12*x0**2 + 6*x1**2 + 7*x2**2 >= 70)

# ... add all other constraints similarly

# Solve model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Hours worked by Bill: ", x0.varValue)
    print("Hours worked by Jean: ", x1.varValue)
    print("Hours worked by John: ", x2.varValue)
    print("Hours worked by Mary: ", x3.varValue)
else:
    print("No optimal solution found")
