
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
network_admins = m.addVar(vtype=gp.GRB.INTEGER, name="network_admins")
pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
security_engineers = m.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")
automatic_alerts = m.addVar(vtype=gp.GRB.INTEGER, name="automatic_alerts")
patches_per_day = m.addVar(vtype=gp.GRB.INTEGER, name="patches_per_day")

# Set objective function
m.setObjective(7.98 * network_admins + 1.19 * pen_testers + 3.31 * security_engineers + 9.04 * automatic_alerts + 2.83 * patches_per_day, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * network_admins + 4 * pen_testers + 15 * security_engineers + 10 * automatic_alerts + 9 * patches_per_day <= 167, "bandwidth")
m.addConstr(15 * network_admins + 5 * pen_testers + 2 * security_engineers + 5 * automatic_alerts + 2 * patches_per_day <= 256, "network_integrity")

m.addConstr(15 * network_admins + 5 * pen_testers + 5 * automatic_alerts >= 41, "combined_impact1")
m.addConstr(15 * network_admins + 2 * security_engineers + 2 * patches_per_day >= 41, "combined_impact2")
m.addConstr(15 * network_admins + 5 * pen_testers + 2 * patches_per_day >= 41, "combined_impact3")
m.addConstr(15 * network_admins + 5 * pen_testers + 5 * automatic_alerts >= 36, "combined_impact4")
m.addConstr(15 * network_admins + 2 * security_engineers + 2 * patches_per_day >= 36, "combined_impact5")
m.addConstr(15 * network_admins + 5 * pen_testers + 2 * patches_per_day >= 36, "combined_impact6")
m.addConstr(15 * network_admins + 5 * pen_testers + 5 * automatic_alerts >= 48, "combined_impact7")
m.addConstr(15 * network_admins + 2 * security_engineers + 2 * patches_per_day >= 48, "combined_impact8")
m.addConstr(15 * network_admins + 5 * pen_testers + 2 * patches_per_day >= 48, "combined_impact9")


m.addConstr(15 * security_engineers + 9 * patches_per_day <= 160, "bandwidth_constraint1")
m.addConstr(6 * network_admins + 9 * patches_per_day <= 89, "bandwidth_constraint2")
m.addConstr(6 * network_admins + 15 * security_engineers <= 167, "bandwidth_constraint3")
m.addConstr(4 * pen_testers + 9 * patches_per_day <= 54, "bandwidth_constraint4")
m.addConstr(6 * network_admins + 10 * automatic_alerts <= 133, "bandwidth_constraint5")
m.addConstr(4 * pen_testers + 15 * security_engineers + 10 * automatic_alerts <= 72, "bandwidth_constraint6")
m.addConstr(6 * network_admins + 4 * pen_testers + 15 * security_engineers + 10 * automatic_alerts + 9 * patches_per_day <= 72, "bandwidth_constraint7")

m.addConstr(15 * network_admins + 2 * security_engineers <= 154, "combined_impact_upper1")
m.addConstr(15 * network_admins + 2 * patches_per_day <= 168, "combined_impact_upper2")
m.addConstr(5 * pen_testers + 5 * automatic_alerts + 2 * patches_per_day <= 234, "combined_impact_upper3")
m.addConstr(15 * network_admins + 5 * pen_testers + 2 * security_engineers + 5 * automatic_alerts + 2 * patches_per_day <= 234, "combined_impact_upper4")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

