
from gurobipy import Model, GRB

# Create a new model
model = Model("EmployeeHoursOptimization")

# Create variables
laura_hours = model.addVar(vtype=GRB.CONTINUOUS, name="laura_hours")
ringo_hours = model.addVar(vtype=GRB.CONTINUOUS, name="ringo_hours")

# Set objective function
model.setObjective(6.49 * laura_hours + 9.41 * ringo_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(8 * laura_hours + 4 * ringo_hours >= 36, "paperwork_min")
model.addConstr(8 * laura_hours + 4 * ringo_hours <= 60, "paperwork_max")

model.addConstr(11 * laura_hours + 7 * ringo_hours >= 44, "organization_min")
model.addConstr(11 * laura_hours + 7 * ringo_hours <= 100, "organization_max")

model.addConstr(7 * laura_hours + 2 * ringo_hours >= 28, "productivity_min")
model.addConstr(7 * laura_hours + 2 * ringo_hours <= 54, "productivity_max")

model.addConstr(10 * laura_hours - 5 * ringo_hours >= 0, "laura_ringo_relation")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Laura's hours: {laura_hours.x}")
    print(f"Ringo's hours: {ringo_hours.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

