
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Decision Variables
x0 = m.addVar(name='hours_worked_by_Laura', lb=0)  # Hours worked by Laura
x1 = m.addVar(name='hours_worked_by_Ringo', lb=0)  # Hours worked by Ringo

# Objective Function: Minimize the total cost
m.setObjective(6.49 * x0 + 9.41 * x1, GRB.MINIMIZE)

# Constraints
# Paperwork competence rating constraints
m.addConstr(8*x0 + 4*x1 >= 36, name='paperwork_min')
m.addConstr(8*x0 + 4*x1 <= 60, name='paperwork_max')

# Organization score constraints
m.addConstr(11*x0 + 7*x1 >= 44, name='organization_min')
m.addConstr(11*x0 + 7*x1 <= 100, name='organization_max')

# Productivity rating constraints
m.addConstr(7*x0 + 2*x1 >= 28, name='productivity_min')
m.addConstr(7*x0 + 2*x1 <= 54, name='productivity_max')

# Additional constraint
m.addConstr(10*x0 - 5*x1 >= 0, name='additional_constraint')

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Laura: {x0.x}")
    print(f"Hours worked by Ringo: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
