
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="hours_worked_by_Laura", lb=0)  # Assuming hours cannot be negative
    x1 = model.addVar(name="hours_worked_by_Ringo", lb=0)  # Assuming hours cannot be negative

    # Objective function: Minimize 6.49*x0 + 9.41*x1
    model.setObjective(6.49 * x0 + 9.41 * x1, gurobi.GRB.MINIMIZE)

    # Constraints
    # Individual constraints (not actually needed as they are constants)
    # model.addConstr(8 * x0 <= 75)  # Laura's paperwork
    # model.addConstr(11 * x0 <= 100)  # Laura's organization
    # model.addConstr(7 * x0 <= 103)  # Laura's productivity
    # model.addConstr(4 * x1 <= 75)  # Ringo's paperwork
    # model.addConstr(7 * x1 <= 100)  # Ringo's organization
    # model.addConstr(2 * x1 <= 103)  # Ringo's productivity

    # Combined constraints
    model.addConstr(8 * x0 + 4 * x1 >= 36)  # Paperwork min
    model.addConstr(11 * x0 + 7 * x1 >= 44)  # Organization min
    model.addConstr(7 * x0 + 2 * x1 >= 28)  # Productivity min

    model.addConstr(8 * x0 + 4 * x1 <= 60)  # Paperwork max
    model.addConstr(11 * x0 + 7 * x1 <= 100)  # Organization max
    model.addConstr(7 * x0 + 2 * x1 <= 54)  # Productivity max

    model.addConstr(10 * x0 - 5 * x1 >= 0)  # Additional constraint

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Hours worked by Laura: {x0.varValue}")
        print(f"Hours worked by Ringo: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
