
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_b4 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b4")
iron = m.addVar(vtype=gp.GRB.INTEGER, name="iron")
protein = m.addVar(vtype=gp.GRB.INTEGER, name="protein")
magnesium = m.addVar(vtype=gp.GRB.CONTINUOUS, name="magnesium")
fiber = m.addVar(vtype=gp.GRB.INTEGER, name="fiber")

# Set objective function
m.setObjective(1 * vitamin_b4 + 5 * iron + 6 * protein + 6 * magnesium + 1 * fiber, gp.GRB.MAXIMIZE)

# Add constraints based on resource attributes
energy_stability_index = {
    'vitamin_b4': 6.98, 'iron': 4.92, 'protein': 7.3, 'magnesium': 6.88, 'fiber': 7.4
}
digestive_support_index = {
    'vitamin_b4': 1.66, 'iron': 2.27, 'protein': 0.85, 'magnesium': 3.09, 'fiber': 1.54
}
cardiovascular_support_index = {
    'vitamin_b4': 4.76, 'iron': 2.2, 'protein': 7.86, 'magnesium': 5.19, 'fiber': 6.11
}
muscle_growth_index = {
    'vitamin_b4': 6.41, 'iron': 6.26, 'protein': 7.12, 'magnesium': 4.7, 'fiber': 4.98
}

resource_upper_bounds = {
    'r0': 201, 'r1': 115, 'r2': 240, 'r3': 222
}


m.addConstr(energy_stability_index['vitamin_b4'] * vitamin_b4 + energy_stability_index['iron'] * iron >= 19)
m.addConstr(energy_stability_index['protein'] * protein + energy_stability_index['fiber'] * fiber >= 15)
m.addConstr(energy_stability_index['protein'] * protein + energy_stability_index['magnesium'] * magnesium >= 17)
m.addConstr(energy_stability_index['iron'] * iron + energy_stability_index['protein'] * protein + energy_stability_index['fiber'] * fiber >= 30)

# ... (Similarly add other constraints using the provided data) ...
# Example for digestive support:
m.addConstr(digestive_support_index['iron'] * iron + digestive_support_index['protein'] * protein + digestive_support_index['magnesium'] * magnesium >= 21)
# ... (Add remaining constraints)

# Energy stability upper bounds
m.addConstr(energy_stability_index['magnesium'] * magnesium + energy_stability_index['fiber'] * fiber <= 176)
# ... (Add remaining upper bound constraints)

# Digestive support upper bounds
m.addConstr(digestive_support_index['vitamin_b4'] * vitamin_b4 + digestive_support_index['protein'] * protein <= 32)
# ... (Add remaining upper bound constraints)

# Cardiovascular support upper bounds
# ... (Add all cardiovascular support upper bound constraints)

# Muscle growth upper bounds
# ... (Add all muscle growth upper bound constraints)

# Additional constraints
m.addConstr(5 * vitamin_b4 - 6 * protein + 9 * fiber >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

