
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
apple_pies = m.addVar(vtype=GRB.INTEGER, name="apple_pies")
lemons = m.addVar(vtype=GRB.INTEGER, name="lemons")
bowls_of_cereal = m.addVar(vtype=GRB.INTEGER, name="bowls_of_cereal")

# Set objective function
m.setObjective(7.06 * apple_pies * lemons + 9.79 * lemons * lemons + 8.75 * lemons * bowls_of_cereal + 8.31 * bowls_of_cereal, GRB.MINIMIZE)

# Add constraints
m.addConstr(12.53 * apple_pies + 10.8 * lemons + 12.65 * bowls_of_cereal <= 143, "iron_upper_bound")  # Resource constraint: iron
m.addConstr(7.39 * apple_pies + 12.51 * lemons + 5.63 * bowls_of_cereal <= 198, "sourness_upper_bound") # Resource constraint: sourness
m.addConstr(7.25 * apple_pies + 0.15 * lemons + 3.3 * bowls_of_cereal <= 127, "carbs_upper_bound") # Resource constraint: carbs

m.addConstr(12.53 * apple_pies * apple_pies + 12.65 * bowls_of_cereal * bowls_of_cereal >= 38, "iron_constraint1")
m.addConstr(12.53 * apple_pies * apple_pies + 10.8 * lemons * lemons + 12.65 * bowls_of_cereal * bowls_of_cereal >= 28, "iron_constraint2")
m.addConstr(12.53 * apple_pies + 10.8 * lemons + 12.65 * bowls_of_cereal >= 28, "iron_constraint3")

m.addConstr(7.39 * apple_pies + 5.63 * bowls_of_cereal >= 42, "sourness_constraint1")
m.addConstr(12.51 * lemons + 5.63 * bowls_of_cereal >= 32, "sourness_constraint2")
m.addConstr(7.39 * apple_pies + 12.51 * lemons + 5.63 * bowls_of_cereal >= 32, "sourness_constraint3")

m.addConstr(7.25 * apple_pies + 3.3 * bowls_of_cereal >= 23, "carbs_constraint1")
m.addConstr(0.15 * lemons * lemons + 3.3 * bowls_of_cereal * bowls_of_cereal >= 36, "carbs_constraint2")
m.addConstr(7.25 * apple_pies + 0.15 * lemons + 3.3 * bowls_of_cereal >= 39, "carbs_constraint3")
m.addConstr(7.25 * apple_pies + 0.15 * lemons + 3.3 * bowls_of_cereal >= 39, "carbs_constraint4")


m.addConstr(12.53 * apple_pies * apple_pies + 12.65 * bowls_of_cereal * bowls_of_cereal <= 114, "iron_constraint4")
m.addConstr(10.8 * lemons + 12.65 * bowls_of_cereal <= 114, "iron_constraint5")

m.addConstr(0.15 * lemons + 3.3 * bowls_of_cereal <= 112, "carbs_constraint5")
m.addConstr(7.25 * apple_pies * apple_pies + 3.3 * bowls_of_cereal * bowls_of_cereal <= 79, "carbs_constraint6")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('apple_pies:', apple_pies.x)
    print('lemons:', lemons.x)
    print('bowls_of_cereal:', bowls_of_cereal.x)
elif m.status == GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

