
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
apple_pies = m.addVar(name="apple_pies", vtype=gp.GRB.INTEGER)
lemons = m.addVar(name="lemons", vtype=gp.GRB.INTEGER)
bowls_of_cereal = m.addVar(name="bowls_of_cereal", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(7.06 * apple_pies * lemons + 9.79 * lemons**2 + 8.75 * lemons * bowls_of_cereal + 8.31 * bowls_of_cereal, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(12.53 * apple_pies <= 143)
m.addConstr(10.8 * lemons <= 143)
m.addConstr(12.65 * bowls_of_cereal <= 143)
m.addConstr(7.39 * apple_pies <= 198)
m.addConstr(12.51 * lemons <= 198)
m.addConstr(5.63 * bowls_of_cereal <= 198)
m.addConstr(7.25 * apple_pies <= 127)
m.addConstr(0.15 * lemons <= 127)
m.addConstr(3.3 * bowls_of_cereal <= 127)
m.addConstr(apple_pies**2 + bowls_of_cereal**2 >= 38)
m.addConstr(apple_pies**2 + lemons**2 + bowls_of_cereal**2 >= 28)
m.addConstr(apple_pies + lemons + bowls_of_cereal >= 28)
m.addConstr(7.39 * apple_pies + 5.63 * bowls_of_cereal >= 42)
m.addConstr(12.51 * lemons + 5.63 * bowls_of_cereal >= 32)
m.addConstr(7.39 * apple_pies + 12.51 * lemons + 5.63 * bowls_of_cereal >= 32)
m.addConstr(7.25 * apple_pies + 3.3 * bowls_of_cereal >= 23)
m.addConstr((0.15 * lemons)**2 + (3.3 * bowls_of_cereal)**2 >= 36)
m.addConstr(7.25 * apple_pies + 0.15 * lemons + 3.3 * bowls_of_cereal >= 39)
m.addConstr(7.25 * apple_pies + 0.15 * lemons + 3.3 * bowls_of_cereal >= 39)
m.addConstr(apple_pies**2 + bowls_of_cereal**2 <= 114)
m.addConstr(lemons + bowls_of_cereal <= 114)
m.addConstr(0.15 * lemons + 3.3 * bowls_of_cereal <= 112)
m.addConstr((7.25 * apple_pies)**2 + (3.3 * bowls_of_cereal)**2 <= 79)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Apple pies: ", apple_pies.varValue)
    print("Lemons: ", lemons.varValue)
    print("Bowls of cereal: ", bowls_of_cereal.varValue)
else:
    print("The problem is infeasible")
