
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="signal_platoons")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="light_infantry_companies")

# Set objective function
m.setObjective(4 * x0 + 4 * x1, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * x0 + 12 * x1 >= 78, "fuel_demand_min")
m.addConstr(5 * x0 + 9 * x1 >= 41, "fun_factor_min")
m.addConstr(13 * x0 + 2 * x1 >= 33, "mobility_rating_min")
m.addConstr(17 * x0 + 8 * x1 >= 17, "deployment_weight_min")
m.addConstr(12 * x0 + 14 * x1 >= 17, "logistics_footprint_min")
m.addConstr(-1 * x0 + 9 * x1 >= 0, "custom_constraint_1")

m.addConstr(4 * x0 + 12 * x1 <= 112, "fuel_demand_max") # Consolidated redundant constraints
m.addConstr(5 * x0 + 9 * x1 <= 126, "fun_factor_max") # Consolidated redundant constraints
m.addConstr(13 * x0 + 2 * x1 <= 62, "mobility_rating_max") # Consolidated redundant constraints
m.addConstr(17 * x0 + 8 * x1 <= 48, "deployment_weight_max") # Consolidated redundant constraints
m.addConstr(12 * x0 + 14 * x1 <= 25, "logistics_footprint_max") # Consolidated redundant constraints


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Signal Platoons: {x0.x}")
    print(f"  Light Infantry Companies: {x1.x}")
    print(f"  Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

