
from gurobipy import *

# Create a new model
m = Model("Optimization_Model")

# Decision Variables
x0 = m.addVar(vtype=GRB.INTEGER, name="Signal_Platons")
x1 = m.addVar(vtype=GRB.INTEGER, name="Light_Infantry_Companies")

# Objective Function: Maximize 4*x0 + 4*x1
m.setObjective(4*x0 + 4*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(4*x0 + 12*x1 >= 78, "Fuel_Demand_Min")
m.addConstr(4*x0 + 12*x1 <= 112, "Fuel_Demand_Max")

m.addConstr(5*x0 + 9*x1 >= 41, "Fun_Factor_Min")
m.addConstr(5*x0 + 9*x1 <= 126, "Fun_Factor_Max")

m.addConstr(13*x0 + 2*x1 >= 33, "Mobility_Rating_Min")
m.addConstr(13*x0 + 2*x1 <= 62, "Mobility_Rating_Max")

m.addConstr(17*x0 + 8*x1 >= 17, "Deployment_Weight_Min")
m.addConstr(17*x0 + 8*x1 <= 48, "Deployment_Weight_Max")

m.addConstr(12*x0 + 14*x1 >= 17, "Logistics_Footprint_Min")
m.addConstr(12*x0 + 14*x1 <= 25, "Logistics_Footprint_Max")

m.addConstr(-x0 + 9*x1 >= 0, "Additional_Constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Signal Platoons: {x0.x}")
    print(f"Light Infantry Companies: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
