
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
signal_platoons = m.addVar(name="signal_platoons", vtype=gp.GRB.INTEGER)
light_infantry_companies = m.addVar(name="light_infantry_companies", vtype=gp.GRB.INTEGER)

# Objective function: maximize 4 * signal platoons + 4 * light_infantry_companies
m.setObjective(4 * signal_platoons + 4 * light_infantry_companies, gp.GRB.MAXIMIZE)

# Constraints
# Fuel demand of signal platoons: 4 * signal_platoons + 12 * light_infantry_companies >= 78
m.addConstr(4 * signal_platoons + 12 * light_infantry_companies >= 78, name="fuel_demand")

# Fun factor: 5 * signal_platoons + 9 * light_infantry_companies >= 41
m.addConstr(5 * signal_platoons + 9 * light_infantry_companies >= 41, name="fun_factor")

# Mobility rating: 13 * signal_platoons + 2 * light_infantry_companies >= 33
m.addConstr(13 * signal_platoons + 2 * light_infantry_companies >= 33, name="mobility_rating")

# Deployment weight: 17 * signal_platoons + 8 * light_infantry_companies >= 17
m.addConstr(17 * signal_platoons + 8 * light_infantry_companies >= 17, name="deployment_weight")

# Logistics footprint: 12 * signal_platoons + 14 * light_infantry_companies >= 17
m.addConstr(12 * signal_platoons + 14 * light_infantry_companies >= 17, name="logistics_footprint")

# Linear constraint: -1 * signal_platoons + 9 * light_infantry_companies >= 0
m.addConstr(-1 * signal_platoons + 9 * light_infantry_companies >= 0, name="linear_constraint")

# Total fuel demand: 4 * signal_platoons + 12 * light_infantry_companies <= 112
m.addConstr(4 * signal_platoons + 12 * light_infantry_companies <= 112, name="total_fuel_demand")

# Total fun factor: 5 * signal_platoons + 9 * light_infantry_companies <= 126
m.addConstr(5 * signal_platoons + 9 * light_infantry_companies <= 126, name="total_fun_factor")

# Total mobility rating: 13 * signal_platoons + 2 * light_infantry_companies <= 62
m.addConstr(13 * signal_platoons + 2 * light_infantry_companies <= 62, name="total_mobility_rating")

# Total deployment weight: 17 * signal_platoons + 8 * light_infantry_companies <= 48
m.addConstr(17 * signal_platoons + 8 * light_infantry_companies <= 48, name="total_deployment_weight")

# Total logistics footprint: 12 * signal_platoons + 14 * light_infantry_companies <= 25
m.addConstr(12 * signal_platoons + 14 * light_infantry_companies <= 25, name="total_logistics_footprint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Signal Platoons: {signal_platoons.varValue}")
    print(f"Light Infantry Companies: {light_infantry_companies.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
