
from gurobipy import Model, GRB

# Create a new model
model = Model("Maximize Employee Output")

# Create variables
jean_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="jean_hours")
laura_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="laura_hours")
mary_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mary_hours")

# Set objective function
model.setObjective(6 * jean_hours + 2 * laura_hours + 8 * mary_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(1.81 * jean_hours + 2.04 * laura_hours >= 141, "c1")
model.addConstr(2.04 * laura_hours + 2.11 * mary_hours <= 327, "c2")
model.addConstr(1.81 * jean_hours + 2.04 * laura_hours <= 321, "c3")
model.addConstr(1.81 * jean_hours + 2.04 * laura_hours + 2.11 * mary_hours <= 321, "c4")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Jean Hours: %g' % jean_hours.x)
    print('Laura Hours: %g' % laura_hours.x)
    print('Mary Hours: %g' % mary_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % model.status)

