
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
J = m.addVar(lb=0, name="hours_worked_by_Jean")
L = m.addVar(lb=0, name="hours_worked_by_Laura")
M = m.addVar(lb=0, name="hours_worked_by_Mary")

# Set the objective function
m.setObjective(6*J + 2*L + 8*M, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.81*J + 2.04*L >= 141, name="constraint_1")
m.addConstr(2.04*L + 2.11*M <= 327, name="constraint_2")
m.addConstr(1.81*J + 2.04*L <= 321, name="constraint_3")
m.addConstr(1.81*J + 2.04*L + 2.11*M <= 321, name="constraint_4")

# Optimize the model
m.optimize()

# Print the solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective: {m.objVal}")
