
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    jean_hours = model.addVar(name="jean_hours", lb=0)  # Lower bound is 0, assuming non-negative hours
    laura_hours = model.addVar(name="laura_hours", lb=0)  # Lower bound is 0, assuming non-negative hours
    mary_hours = model.addVar(name="mary_hours", lb=0)  # Lower bound is 0, assuming non-negative hours

    # Define coefficients for the objective function
    model.setObjective(6 * jean_hours + 2 * laura_hours + 8 * mary_hours, gurobi.GRB.MAXIMIZE)

    # Define likelihood to quit indices
    r0_jean = 1.81
    r0_laura = 2.04
    r0_mary = 2.11

    # Add constraints
    model.addConstr(r0_jean * jean_hours + r0_laura * laura_hours >= 141)
    model.addConstr(r0_laura * laura_hours + r0_mary * mary_hours <= 327)
    model.addConstr(r0_jean * jean_hours + r0_laura * laura_hours <= 321)
    model.addConstr(r0_jean * jean_hours + r0_laura * laura_hours + r0_mary * mary_hours <= 321)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Jean's hours: ", jean_hours.varValue)
        print("Laura's hours: ", laura_hours.varValue)
        print("Mary's hours: ", mary_hours.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
