
import gurobipy as gp

# Create a new model
m = gp.Model("resource_optimization")

# Create variables
intrusion_analysts = m.addVar(vtype=gp.GRB.INTEGER, name="intrusion_analysts")
honeypots = m.addVar(vtype=gp.GRB.INTEGER, name="honeypots")

# Set objective function
m.setObjective(6.44 * intrusion_analysts + 9.58 * honeypots, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * intrusion_analysts + 18 * honeypots >= 40, "power_consumption_min") # Combined power consumption minimum
m.addConstr(4 * intrusion_analysts + 8 * honeypots >= 13, "computational_load_min") # Combined computational load minimum
m.addConstr(6 * intrusion_analysts - 4 * honeypots >= 0, "intrusion_analysts_honeypots_ratio")
m.addConstr(5 * intrusion_analysts + 18 * honeypots <= 86, "power_consumption_max") # Combined power consumption maximum
m.addConstr(4 * intrusion_analysts + 8 * honeypots <= 59, "computational_load_max") # Combined computational load maximum


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Intrusion Analysts: %g' % intrusion_analysts.x)
    print('Honeypots: %g' % honeypots.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

