
from gurobipy import *

# Create a new model
m = Model("Optimization_Model")

# Define variables
intrusion_analysts = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")
honeypots = m.addVar(vtype=GRB.INTEGER, name="honeypots")

# Objective function: Minimize 6.44*intrusion_analysts + 9.58*honypots
m.setObjective(6.44 * intrusion_analysts + 9.58 * honeypots, GRB.MINIMIZE)

# Constraints:
# Power consumption constraints
m.addConstr(5 * intrusion_analysts + 18 * honeypots >= 40, name="min_power_consumption")
m.addConstr(5 * intrusion_analysts + 18 * honeypots <= 86, name="max_power_consumption")

# Computational load constraints
m.addConstr(4 * intrusion_analysts + 8 * honeypots >= 13, name="min_computational_load")
m.addConstr(4 * intrusion_analysts + 8 * honeypots <= 59, name="max_computational_load")

# Additional constraint
m.addConstr(6 * intrusion_analysts - 4 * honeypots >= 0, name="additional_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Intrusion Analysts: {intrusion_analysts.x}")
    print(f"Honeypots: {honeypots.x}")
else:
    print("No optimal solution found.")
