
import gurobi as gp

# Create a new model
m = gp.Model("intrusion_analysts_honeypots")

# Define the variables
intrusion_analysts = m.addVar(name="intrusion_analysts", vtype=gp.GRB.INTEGER)
honeypots = m.addVar(name="honeypots", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(6.44 * intrusion_analysts + 9.58 * honeypots, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(5 * intrusion_analysts + 18 * honeypots >= 40, name="power_min")
m.addConstr(5 * intrusion_analysts + 18 * honeypots <= 88, name="power_max")
m.addConstr(4 * intrusion_analysts + 8 * honeypots >= 13, name="computational_load_min")
m.addConstr(4 * intrusion_analysts + 8 * honeypots <= 77, name="computational_load_max")
m.addConstr(6 * intrusion_analysts - 4 * honeypots >= 0, name="additional_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Intrusion Analysts: {intrusion_analysts.varValue}")
    print(f"Honeypots: {honeypots.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
