
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
cornichons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cornichons")
apple_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")
bacon_strips = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bacon_strips")
cheeseburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")

# Set objective function
m.setObjective(2.18 * cornichons + 4.04 * apple_pies + 4.38 * bacon_strips + 6.25 * cheeseburgers, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(25 * apple_pies + 11 * cheeseburgers >= 102, "c1")
m.addConstr(5 * cornichons + 11 * cheeseburgers >= 136, "c2")
m.addConstr(5 * cornichons + 26 * bacon_strips >= 98, "c3")
m.addConstr(25 * apple_pies + 26 * bacon_strips >= 102, "c4")
m.addConstr(5 * cornichons + 26 * bacon_strips + 11 * cheeseburgers >= 121, "c5")
m.addConstr(32 * apple_pies + 4 * cheeseburgers >= 59, "c6")
m.addConstr(13 * bacon_strips + 4 * cheeseburgers >= 46, "c7")
m.addConstr(21 * cornichons + 32 * apple_pies >= 46, "c8")
m.addConstr(21 * cornichons + 4 * cheeseburgers >= 50, "c9")
m.addConstr(21 * cornichons + 13 * bacon_strips + 4 * cheeseburgers >= 41, "c10")
m.addConstr(6 * bacon_strips - 9 * cheeseburgers >= 0, "c11")
m.addConstr(5 * cornichons + 11 * cheeseburgers <= 403, "c12")
m.addConstr(25 * apple_pies + 26 * bacon_strips <= 553, "c13")
m.addConstr(5 * cornichons + 25 * apple_pies <= 377, "c14")
m.addConstr(25 * apple_pies + 11 * cheeseburgers <= 459, "c15")
m.addConstr(26 * bacon_strips + 11 * cheeseburgers <= 358, "c16")
m.addConstr(25 * apple_pies + 26 * bacon_strips + 11 * cheeseburgers <= 537, "c17")
m.addConstr(5 * cornichons + 25 * apple_pies + 26 * bacon_strips + 11 * cheeseburgers <= 537, "c18")  # corrected constraint
m.addConstr(21 * cornichons + 32 * apple_pies <= 182, "c19")
m.addConstr(13 * bacon_strips + 4 * cheeseburgers <= 218, "c20")
m.addConstr(21 * cornichons + 32 * apple_pies + 13 * bacon_strips + 4 * cheeseburgers <= 218, "c21")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

