
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    magnesium = m.addVar(lb=0, name="magnesium")
    vitamin_b2 = m.addVar(lb=0, name="vitamin_b2")
    vitamin_c = m.addVar(lb=0, name="vitamin_c")
    vitamin_b6 = m.addVar(lb=0, name="vitamin_b6")

    # Set objective function
    m.setObjective(5.28 * magnesium + 4.71 * vitamin_b2 + 8.96 * vitamin_c + 6.81 * vitamin_b6, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4.9 * magnesium + 4.7 * vitamin_c >= 37, "c0")
    m.addConstr(4.36 * vitamin_b2 + 4.7 * vitamin_c >= 26, "c1")
    m.addConstr(3.03 * vitamin_b2 + 4.5 * vitamin_c >= 36, "c2")
    m.addConstr(4.9 * magnesium + 4.36 * vitamin_b2 <= 101, "c3")
    m.addConstr(4.9 * magnesium + 5.86 * vitamin_b6 <= 96, "c4")
    m.addConstr(4.7 * vitamin_c + 5.86 * vitamin_b6 <= 69, "c5")
    m.addConstr(4.36 * vitamin_b2 + 5.86 * vitamin_b6 <= 141, "c6")
    m.addConstr(4.9 * magnesium + 4.7 * vitamin_c + 5.86 * vitamin_b6 <= 185, "c7")
    m.addConstr(4.9 * magnesium + 4.36 * vitamin_b2 + 5.86 * vitamin_b6 <= 100, "c8")
    m.addConstr(4.36 * vitamin_b2 + 4.7 * vitamin_c + 5.86 * vitamin_b6 <= 157, "c9")
    m.addConstr(4.9 * magnesium + 4.36 * vitamin_b2 + 4.7 * vitamin_c + 5.86 * vitamin_b6 <= 157, "c10")
    m.addConstr(5.9 * magnesium + 1.5 * vitamin_b6 <= 71, "c11")
    m.addConstr(4.5 * vitamin_c + 1.5 * vitamin_b6 <= 71, "c12")
    m.addConstr(3.03 * vitamin_b2 + 1.5 * vitamin_b6 <= 186, "c13")
    m.addConstr(5.9 * magnesium + 3.03 * vitamin_b2 <= 188, "c14")
    m.addConstr(3.03 * vitamin_b2 + 4.5 * vitamin_c <= 87, "c15")
    m.addConstr(5.9 * magnesium + 4.5 * vitamin_c <= 164, "c16")
    m.addConstr(5.9 * magnesium + 3.03 * vitamin_b2 + 1.5 * vitamin_b6 <= 157, "c17")
    m.addConstr(5.9 * magnesium + 3.03 * vitamin_b2 + 4.5 * vitamin_c <= 150, "c18")
    m.addConstr(5.9 * magnesium + 3.03 * vitamin_b2 + 4.5 * vitamin_c + 1.5 * vitamin_b6 <= 150, "c19")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
