
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_b1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b1")
fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
carbohydrates = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbohydrates")
protein = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein")

# Set objective function
m.setObjective(6*vitamin_b1 + 1*fat + 1*carbohydrates + 2*protein, gp.GRB.MINIMIZE)

# Add constraints based on resource attributes
resources = {
    'r0': {'description': 'digestive support index', 'upper_bound': 134, 'x0': 7, 'x1': 6, 'x2': 13, 'x3': 3},
    'r1': {'description': 'cardiovascular support index', 'upper_bound': 321, 'x0': 10, 'x1': 9, 'x2': 20, 'x3': 12},
    'r2': {'description': 'muscle growth index', 'upper_bound': 402, 'x0': 4, 'x1': 26, 'x2': 6, 'x3': 12},
    'r3': {'description': 'cognitive performance index', 'upper_bound': 451, 'x0': 3, 'x1': 15, 'x2': 19, 'x3': 3}
}

for r_id, r_data in resources.items():
    m.addConstr(r_data['x0']*vitamin_b1 + r_data['x1']*fat + r_data['x2']*carbohydrates + r_data['x3']*protein <= r_data['upper_bound'], name=f"{r_data['description']}_upper_bound")


# Add other constraints as specified in the prompt
m.addConstr(7*vitamin_b1 + 6*fat >= 21, "digestive_support_1")
m.addConstr(7*vitamin_b1 + 3*protein >= 29, "digestive_support_2")
m.addConstr(6*fat + 13*carbohydrates >= 15, "digestive_support_3")
m.addConstr(7*vitamin_b1 + 6*fat + 13*carbohydrates >= 30, "digestive_support_4")
m.addConstr(6*fat + 13*carbohydrates + 3*protein >= 30, "digestive_support_5")
m.addConstr(7*vitamin_b1 + 13*carbohydrates + 3*protein >= 30, "digestive_support_6")
m.addConstr(7*vitamin_b1 + 6*fat + 13*carbohydrates >= 16, "digestive_support_7")
m.addConstr(6*fat + 13*carbohydrates + 3*protein >= 16, "digestive_support_8")
m.addConstr(7*vitamin_b1 + 13*carbohydrates + 3*protein >= 16, "digestive_support_9")
m.addConstr(7*vitamin_b1 + 6*fat + 13*carbohydrates >= 33, "digestive_support_10")
m.addConstr(6*fat + 13*carbohydrates + 3*protein >= 33, "digestive_support_11")
m.addConstr(7*vitamin_b1 + 13*carbohydrates + 3*protein >= 33, "digestive_support_12")
m.addConstr(7*vitamin_b1 + 6*fat + 13*carbohydrates + 3*protein >= 33, "digestive_support_13")

m.addConstr(10*vitamin_b1 + 20*carbohydrates >= 44, "cardiovascular_support_1")
m.addConstr(9*fat + 20*carbohydrates >= 44, "cardiovascular_support_2")
m.addConstr(10*vitamin_b1 + 9*fat + 12*protein >= 69, "cardiovascular_support_3")
m.addConstr(10*vitamin_b1 + 9*fat + 20*carbohydrates + 12*protein >= 69, "cardiovascular_support_4")

m.addConstr(6*carbohydrates + 12*protein >= 41, "muscle_growth_1")
m.addConstr(26*fat + 12*protein >= 91, "muscle_growth_2")
m.addConstr(4*vitamin_b1 + 6*carbohydrates >= 39, "muscle_growth_3")
m.addConstr(4*vitamin_b1 + 26*fat + 6*carbohydrates + 12*protein >= 39, "muscle_growth_4")

m.addConstr(3*vitamin_b1 + 19*carbohydrates >= 102, "cognitive_performance_1")
m.addConstr(3*vitamin_b1 + 15*fat + 19*carbohydrates + 3*protein >= 102, "cognitive_performance_2")

m.addConstr(-4*vitamin_b1 + 6*carbohydrates >= 0, "constraint_1")
m.addConstr(-8*fat + 6*protein >= 0, "constraint_2")
m.addConstr(6*fat + 13*carbohydrates + 3*protein <= 87, "constraint_3")
m.addConstr(4*vitamin_b1 + 26*fat + 6*carbohydrates <= 154, "constraint_4")
m.addConstr(19*carbohydrates + 3*protein <= 421, "constraint_5")
m.addConstr(3*vitamin_b1 + 15*fat <= 347, "constraint_6")
m.addConstr(3*vitamin_b1 + 15*fat + 19*carbohydrates <= 285, "constraint_7")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")
