
import gurobipy as gp

# Create a new model
m = gp.Model("nutrient_optimization")

# Create variables
vitamin_b9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")
magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")

# Set objective function
m.setObjective(8 * vitamin_b9 + 7 * magnesium + 7 * calcium, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * vitamin_b9 + 12 * calcium >= 35, "digestive_constraint1")
m.addConstr(9 * vitamin_b9 + 13 * magnesium + 12 * calcium >= 56, "digestive_constraint2")
m.addConstr(9 * vitamin_b9 + 13 * magnesium + 12 * calcium >= 56, "digestive_constraint3")  # Redundant
m.addConstr(5 * vitamin_b9 + 17 * calcium >= 112, "kidney_constraint1")
m.addConstr(23 * magnesium + 17 * calcium >= 79, "kidney_constraint2")
m.addConstr(5 * vitamin_b9 + 23 * magnesium >= 112, "kidney_constraint3")
m.addConstr(5 * vitamin_b9 + 23 * magnesium + 17 * calcium >= 112, "kidney_constraint4")
m.addConstr(-3 * magnesium + 8 * calcium >= 0, "constraint7")
m.addConstr(-3 * vitamin_b9 + 10 * calcium >= 0, "constraint8")
m.addConstr(13 * magnesium + 12 * calcium <= 213, "digestive_constraint4")
m.addConstr(9 * vitamin_b9 + 12 * calcium <= 104, "digestive_constraint5")
m.addConstr(9 * vitamin_b9 + 13 * magnesium + 12 * calcium <= 255, "digestive_constraint6")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_b9:', vitamin_b9.x)
    print('magnesium:', magnesium.x)
    print('calcium:', calcium.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

