
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name='milligrams_of_vitamin_B9', lb=0)  # Non-negative, can be fractional
x1 = m.addVar(name='milligrams_of_magnesium', lb=0)   # Non-negative, can be fractional
x2 = m.addVar(name='milligrams_of_calcium', lb=0)     # Non-negative, can be fractional

# Objective function: Minimize 8*x0 + 7*x1 + 7*x2
m.setObjective(8*x0 + 7*x1 + 7*x2, GRB.MINIMIZE)

# Constraints:
# Digestive support index constraints
m.addConstr(9*x0 + 13*x1 + 12*x2 >= 56, name='total_digestive_support_min')
m.addConstr(9*x0 + 13*x1 + 12*x2 <= 255, name='total_digestive_support_max')
m.addConstr(9*x0 + 12*x2 >= 35, name='vitamin_b9_and_calcium_digestive_support_min')
m.addConstr(13*x1 + 12*x2 <= 213, name='magnesium_and_calcium_digestive_support_max')
m.addConstr(9*x0 + 12*x2 <= 104, name='vitamin_b9_and_calcium_digestive_support_max')

# Kidney support index constraints
m.addConstr(5*x0 + 17*x2 >= 112, name='vitamin_b9_and_calcium_kidney_support_min')
m.addConstr(23*x1 + 17*x2 >= 79, name='magnesium_and_calcium_kidney_support_min')
m.addConstr(5*x0 + 23*x1 >= 112, name='vitamin_b9_and_magnesium_kidney_support_min')
m.addConstr(5*x0 + 23*x1 + 17*x2 >= 112, name='total_kidney_support_min')

# Additional linear inequalities
m.addConstr(-3*x1 + 8*x2 >= 0, name='magnesium_and_calcium_inequality')
m.addConstr(-3*x0 + 10*x2 >= 0, name='vitamin_b9_and_calcium_inequality')

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of Vitamin B9: {x0.x}")
    print(f"Milligrams of Magnesium: {x1.x}")
    print(f"Milligrams of Calcium: {x2.x}")
else:
    print("No optimal solution found.")
