
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(lb=0, name="milligrams of vitamin B9")  # No lower bound specified, assuming 0
x1 = model.addVar(lb=0, name="milligrams of magnesium")  # No lower bound specified, assuming 0
x2 = model.addVar(lb=0, name="milligrams of calcium")  # No lower bound specified, assuming 0

# Objective function: Minimize 8x0 + 7x1 + 7x2
model.setObjective(8 * x0 + 7 * x1 + 7 * x2, gurobi.GRB.MINIMIZE)

# Constraints
# Digestive support index constraints
model.addConstr(9 * x0 + 13 * x1 + 12 * x2 <= 284, name="digestive_support_index_total")
model.addConstr(9 * x0 + 12 * x2 >= 35, name="digestive_support_index_B9_Ca")
model.addConstr(9 * x0 + 13 * x1 + 12 * x2 >= 56, name="digestive_support_index_total_B9_Mg_Ca")
model.addConstr(13 * x1 + 12 * x2 <= 213, name="digestive_support_index_Mg_Ca")
model.addConstr(9 * x0 + 12 * x2 <= 104, name="digestive_support_index_B9_Ca_max")
model.addConstr(9 * x0 + 13 * x1 + 12 * x2 <= 255, name="digestive_support_index_total_max")

# Kidney support index constraints
model.addConstr(5 * x0 + 23 * x1 + 17 * x2 <= 392, name="kidney_support_index_total")
model.addConstr(5 * x0 + 17 * x2 >= 112, name="kidney_support_index_B9_Ca")
model.addConstr(23 * x1 + 17 * x2 >= 79, name="kidney_support_index_Mg_Ca")
model.addConstr(5 * x0 + 23 * x1 >= 112, name="kidney_support_index_B9_Mg")
model.addConstr(5 * x0 + 23 * x1 + 17 * x2 >= 112, name="kidney_support_index_total_B9_Mg_Ca")

# Additional constraints
model.addConstr(-3 * x1 + 8 * x2 >= 0, name="Mg_Ca_constraint")
model.addConstr(-3 * x0 + 10 * x2 >= 0, name="B9_Ca_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of vitamin B9: ", x0.varValue)
    print("Milligrams of magnesium: ", x1.varValue)
    print("Milligrams of calcium: ", x2.varValue)
    print("Objective function value: ", model.objVal)
else:
    print("No optimal solution found.")
