
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
oreos = m.addVar(lb=0, name="oreos", vtype=gurobi.GRB.CONTINUOUS)
ham_sandwiches = m.addVar(lb=0, name="ham_sandwiches", vtype=gurobi.GRB.CONTINUOUS)
chicken_drumsticks = m.addVar(lb=0, name="chicken_drumsticks", vtype=gurobi.GRB.CONTINUOUS)

# Define the objective function
m.setObjective(9.79 * oreos + 6.05 * ham_sandwiches + 7.14 * chicken_drumsticks, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9 * oreos + 11 * ham_sandwiches + 3 * chicken_drumsticks <= 108)
m.addConstr(10 * oreos + 8 * ham_sandwiches + 8 * chicken_drumsticks <= 104)
m.addConstr(9 * oreos + 10 * ham_sandwiches + 8 * chicken_drumsticks <= 152)
m.addConstr(2 * oreos + 3 * ham_sandwiches + 2 * chicken_drumsticks <= 134)
m.addConstr(8 * oreos + 11 * ham_sandwiches + 3 * chicken_drumsticks <= 115)

m.addConstr(8 * ham_sandwiches + 8 * chicken_drumsticks >= 20)
m.addConstr(10 * oreos + 8 * chicken_drumsticks >= 33)
m.addConstr(2 * oreos + 3 * ham_sandwiches + 2 * chicken_drumsticks >= 40)

m.addConstr(9 * oreos + 3 * chicken_drumsticks <= 102)
m.addConstr(11 * ham_sandwiches + 3 * chicken_drumsticks <= 98)
m.addConstr(9 * oreos + 11 * ham_sandwiches + 3 * chicken_drumsticks <= 67)

m.addConstr(10 * oreos + 8 * chicken_drumsticks <= 90)
m.addConstr(10 * oreos + 8 * ham_sandwiches + 8 * chicken_drumsticks <= 74)

m.addConstr(9 * oreos + 8 * chicken_drumsticks <= 76)
m.addConstr(10 * ham_sandwiches + 8 * chicken_drumsticks <= 74)
m.addConstr(9 * oreos + 10 * ham_sandwiches + 8 * chicken_drumsticks <= 74)

m.addConstr(2 * oreos + 3 * ham_sandwiches <= 67)
m.addConstr(2 * oreos + 2 * chicken_drumsticks <= 101)
m.addConstr(2 * oreos + 3 * ham_sandwiches + 2 * chicken_drumsticks <= 101)

m.addConstr(8 * oreos + 11 * ham_sandwiches <= 58)
m.addConstr(8 * oreos + 11 * ham_sandwiches + 3 * chicken_drumsticks <= 58)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Oreos: ", oreos.varValue)
    print("Ham Sandwiches: ", ham_sandwiches.varValue)
    print("Chicken Drumsticks: ", chicken_drumsticks.varValue)
else:
    print("The model is infeasible")
