
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
iron = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="iron")
fiber = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="fiber")
vit_A = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vit_A")
vit_B6 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vit_B6")
vit_B4 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vit_B4")

# Set objective function
m.setObjective(1.31 * fat + 2.12 * iron + 6.66 * fiber + 9.2 * vit_A + 1.93 * vit_B6 + 6.97 * vit_B4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9 * vit_A + 9 * vit_B6 >= 44, "c1")
m.addConstr(2 * fat + 1 * fiber + 9 * vit_A >= 54, "c2")
m.addConstr(2 * fat + 3 * iron <= 291, "c3")
m.addConstr(3 * iron + 1 * fiber <= 96, "c4")
m.addConstr(3 * iron + 2 * vit_B4 <= 282, "c5")
m.addConstr(3 * iron + 9 * vit_A <= 234, "c6")
m.addConstr(9 * vit_A + 9 * vit_B6 <= 97, "c7")
m.addConstr(2 * fat + 2 * vit_B4 <= 235, "c8")
m.addConstr(1 * fiber + 2 * vit_B4 <= 82, "c9")
m.addConstr(9 * vit_B6 + 2 * vit_B4 <= 80, "c10")
m.addConstr(2 * fat + 1 * fiber <= 337, "c11")
m.addConstr(2 * fat + 3 * iron + 1 * fiber + 9 * vit_A + 9 * vit_B6 + 2 * vit_B4 <= 337, "c12")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

