
from gurobipy import *

# Create a new model
m = Model("Nutrition_Optimization")

# Define variables - all are non-negative by default in Gurobi
grams_of_fat = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="grams_of_fat")
milligrams_of_iron = m.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams_of_iron")
grams_of_fiber = m.addVar(lb=0, vtype=GRB.INTEGER, name="grams_of_fiber")
milligrams_of_vitamin_A = m.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams_of_vitamin_A")
milligrams_of_vitamin_B6 = m.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams_of_vitamin_B6")
milligrams_of_vitamin_B4 = m.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams_of_vitamin_B4")

# Objective function
m.setObjective(1.31*grams_of_fat + 2.12*milligrams_of_iron + 6.66*grams_of_fiber +
               9.2*milligrams_of_vitamin_A + 1.93*milligrams_of_vitamin_B6 +
               6.97*milligrams_of_vitamin_B4, GRB.MAXIMIZE)

# Constraints
m.addConstr(2*grams_of_fat + 3*milligrams_of_iron + grams_of_fiber + 
            9*milligrams_of_vitamin_A + 9*milligrams_of_vitamin_B6 + 
            2*milligrams_of_vitamin_B4 <= 344, name="cardiovascular_support_index")

# Additional constraints based on problem description
m.addConstr(9*milligrams_of_vitamin_A + 9*milligrams_of_vitamin_B6 >= 44)
m.addConstr(2*grams_of_fat + grams_of_fiber + 9*milligrams_of_vitamin_A >= 54)
m.addConstr(2*grams_of_fat + 3*milligrams_of_iron <= 291)
m.addConstr(3*milligrams_of_iron + grams_of_fiber <= 96)
m.addConstr(3*milligrams_of_iron + 2*milligrams_of_vitamin_B4 <= 282)
m.addConstr(3*milligrams_of_iron + 9*milligrams_of_vitamin_A <= 234)
m.addConstr(9*milligrams_of_vitamin_A + 9*milligrams_of_vitamin_B6 <= 97)
m.addConstr(2*grams_of_fat + 2*milligrams_of_vitamin_B4 <= 235)
m.addConstr(grams_of_fiber + 2*milligrams_of_vitamin_B4 <= 82)
m.addConstr(9*milligrams_of_vitamin_B6 + 2*milligrams_of_vitamin_B4 <= 80)
m.addConstr(2*grams_of_fat + grams_of_fiber <= 337)
m.addConstr(2*grams_of_fat + 3*milligrams_of_iron + grams_of_fiber +
            9*milligrams_of_vitamin_A + 9*milligrams_of_vitamin_B6 +
            2*milligrams_of_vitamin_B4 <= 337)

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))
