
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="grams_of_fat")  # continuous
x1 = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="milligrams_of_iron")
x2 = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="grams_of_fiber")
x3 = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="milligrams_of_vitamin_A")
x4 = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="milligrams_of_vitamin_B6")
x5 = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="milligrams_of_vitamin_B4")

# Objective function
m.setObjective(1.31*x0 + 2.12*x1 + 6.66*x2 + 9.2*x3 + 1.93*x4 + 6.97*x5, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(2*x0 + 3*x1 + 1*x2 + 9*x3 + 9*x4 + 2*x5 <= 344)
m.addConstr(9*x3 + 9*x4 >= 44)
m.addConstr(2*x0 + 1*x2 + 9*x3 >= 54)
m.addConstr(2*x0 + 3*x1 <= 291)
m.addConstr(3*x1 + 1*x2 <= 96)
m.addConstr(3*x1 + 2*x5 <= 282)
m.addConstr(3*x1 + 9*x3 <= 234)
m.addConstr(9*x3 + 9*x4 <= 97)
m.addConstr(2*x0 + 2*x5 <= 235)
m.addConstr(1*x2 + 2*x5 <= 82)
m.addConstr(9*x4 + 2*x5 <= 80)
m.addConstr(2*x0 + 1*x2 <= 337)
m.addConstr(2*x0 + 3*x1 + 1*x2 + 9*x3 + 9*x4 + 2*x5 <= 337)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Objective value:", m.objVal)
    print("Variables:")
    print("x0 (grams of fat):", x0.varValue)
    print("x1 (milligrams of iron):", x1.varValue)
    print("x2 (grams of fiber):", x2.varValue)
    print("x3 (milligrams of vitamin A):", x3.varValue)
    print("x4 (milligrams of vitamin B6):", x4.varValue)
    print("x5 (milligrams of vitamin B4):", x5.varValue)
else:
    print("No optimal solution found.")
