
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_A = m.addVar(lb=0, name="vitamin_A")  # Continuous
vitamin_B1 = m.addVar(lb=0, name="vitamin_B1") # Continuous
vitamin_B2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_B2") # Integer

# Set objective function
m.setObjective(9.2 * vitamin_A**2 + 3.11 * vitamin_A * vitamin_B1 + 3.0 * vitamin_B2**2 + 4.71 * vitamin_B1 + 2.77 * vitamin_B2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10 * vitamin_A + 9 * vitamin_B1 + 4 * vitamin_B2 <= 139, "muscle_growth_index") # Resource constraint
m.addConstr(4 * vitamin_A + 12 * vitamin_B1 + 8 * vitamin_B2 <= 52, "cognitive_performance_index") # Resource constraint

m.addConstr(9 * vitamin_B1**2 + 4 * vitamin_B2**2 >= 46, "muscle_growth_B1_B2")
m.addConstr(10 * vitamin_A + 4 * vitamin_B2 >= 27, "muscle_growth_A_B2")
m.addConstr(10 * vitamin_A + 9 * vitamin_B1 >= 36, "muscle_growth_A_B1")
m.addConstr(10 * vitamin_A + 9 * vitamin_B1 + 4 * vitamin_B2 >= 36, "muscle_growth_total")

m.addConstr(4 * vitamin_A + 8 * vitamin_B2 >= 14, "cognitive_performance_A_B2")
m.addConstr(12 * vitamin_B1 + 8 * vitamin_B2 >= 6, "cognitive_performance_B1_B2")
m.addConstr(4 * vitamin_A + 12 * vitamin_B1 + 8 * vitamin_B2 >= 6, "cognitive_performance_total")

m.addConstr(4 * vitamin_A - 4 * vitamin_B2 >= 0, "constraint_A_B2")
m.addConstr(4 * vitamin_A + 12 * vitamin_B1 <= 43, "cognitive_performance_A_B1")
m.addConstr(4 * vitamin_A + 8 * vitamin_B2 <= 18, "cognitive_performance_A_B2_upper")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Vitamin A: %g' % vitamin_A.x)
    print('Vitamin B1: %g' % vitamin_B1.x)
    print('Vitamin B2: %g' % vitamin_B2.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

