
import gurobi as gp

# Define the model
m = gp.Model("vitamin_optimization")

# Define the variables
vitamin_A = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="vitamin_A")
vitamin_B1 = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="vitamin_B1")
vitamin_B2 = m.addVar(lb=0, ub=gp.GRB.INFINITY, type=gp.GRB.INTEGER, name="vitamin_B2")

# Objective function
m.setObjective(9.2 * vitamin_A**2 + 3.11 * vitamin_A * vitamin_B1 + 3.0 * vitamin_B2**2 + 4.71 * vitamin_B1 + 2.77 * vitamin_B2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(vitamin_A * 10 == 10, name="muscle_growth_index_vitamin_A")
m.addConstr(vitamin_A * 4 == 4, name="cognitive_performance_index_vitamin_A")
m.addConstr(vitamin_B1 * 9 == 9, name="muscle_growth_index_vitamin_B1")
m.addConstr(vitamin_B1 * 12 == 12, name="cognitive_performance_index_vitamin_B1")
m.addConstr(vitamin_B2 * 4 == 4, name="muscle_growth_index_vitamin_B2")
m.addConstr(vitamin_B2 * 8 == 8, name="cognitive_performance_index_vitamin_B2")

m.addConstr(vitamin_B1**2 + vitamin_B2**2 >= 46, name="combined_muscle_growth_index_B1_B2")
m.addConstr(vitamin_A + vitamin_B2 >= 27, name="combined_muscle_growth_index_A_B2")
m.addConstr(vitamin_A + vitamin_B1 >= 36, name="combined_muscle_growth_index_A_B1")
m.addConstr(vitamin_A + vitamin_B1 + vitamin_B2 >= 36, name="combined_muscle_growth_index_A_B1_B2")

m.addConstr(vitamin_A + vitamin_B2 >= 14, name="combined_cognitive_performance_index_A_B2")
m.addConstr(vitamin_B1 + vitamin_B2 >= 6, name="combined_cognitive_performance_index_B1_B2")
m.addConstr(vitamin_A + vitamin_B1 + vitamin_B2 >= 6, name="combined_cognitive_performance_index_A_B1_B2")

m.addConstr(4 * vitamin_A - 4 * vitamin_B2 >= 0, name="vitamin_A_B2_constraint")
m.addConstr(vitamin_A + vitamin_B1 <= 43, name="combined_cognitive_performance_index_A_B1")
m.addConstr(vitamin_A + vitamin_B2 <= 18, name="combined_cognitive_performance_index_A_B2")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin A: {vitamin_A.varValue}")
    print(f"Milligrams of vitamin B1: {vitamin_B1.varValue}")
    print(f"Milligrams of vitamin B2: {vitamin_B2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
