
import gurobipy as gp

# Create a new model
m = gp.Model("pizza_chicken_optimization")

# Create variables
pizza = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="slices_of_pizza")
chicken = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")

# Set objective function
m.setObjective(4.05 * pizza + 6.13 * chicken, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(18 * pizza + 15 * chicken >= 101, "min_cost")  # Minimum cost
m.addConstr(8 * pizza - 4 * chicken >= 0, "pizza_chicken_ratio")  # Pizza-chicken ratio
m.addConstr(18 * pizza + 15 * chicken <= 177, "max_cost") # Maximum cost


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Slices of pizza: {pizza.x}")
    print(f"Chicken breasts: {chicken.x}")
    print(f"Total cost: ${18 * pizza.x + 15 * chicken.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

