
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
slices_of_pizza = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="slices_of_pizza")
chicken_breasts = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_breasts")

# Set the objective function
m.setObjective(4.05 * slices_of_pizza + 6.13 * chicken_breasts, GRB.MINIMIZE)

# Add constraints
m.addConstr(18 * slices_of_pizza + 15 * chicken_breasts >= 101, name="min_cost_constraint")
m.addConstr(18 * slices_of_pizza + 15 * chicken_breasts <= 177, name="max_cost_constraint")
m.addConstr(8 * slices_of_pizza - 4 * chicken_breasts >= 0, name="linear_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"slices_of_pizza: {slices_of_pizza.x}")
    print(f"chicken_breasts: {chicken_breasts.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found. The model is either infeasible or unbounded.")
