
import gurobipy as gp

# Create a new model
m = gp.Model("pizza_chicken")

# Define the variables
slices_of_pizza = m.addVar(name="slices_of_pizza", lb=0)  # Non-negative
chicken_breasts = m.addVar(name="chicken_breasts", lb=0)  # Non-negative

# Objective function
m.setObjective(4.05 * slices_of_pizza + 6.13 * chicken_breasts, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(18 * slices_of_pizza + 15 * chicken_breasts >= 101, name="min_spend")
m.addConstr(8 * slices_of_pizza - 4 * chicken_breasts >= 0, name="balance")
m.addConstr(18 * slices_of_pizza + 15 * chicken_breasts <= 177, name="max_spend")

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Slices of Pizza: {slices_of_pizza.varValue}")
    print(f"Chicken Breasts: {chicken_breasts.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
