
from gurobipy import Model, GRB

# Create a new model
m = Model("employee_scheduling")

# Create variables
laura_hours = m.addVar(lb=0, name="laura_hours")
george_hours = m.addVar(lb=0, name="george_hours")
paul_hours = m.addVar(lb=0, name="paul_hours")

# Set objective function
m.setObjective(4 * laura_hours**2 + 8 * laura_hours * george_hours + 2 * george_hours * paul_hours + 2 * paul_hours**2 + 4 * paul_hours, GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * laura_hours**2 + 3 * george_hours**2 >= 24, "computer_competence_1")
m.addConstr(7 * laura_hours + 3 * paul_hours >= 23, "computer_competence_2")
m.addConstr(7 * laura_hours**2 + 3 * george_hours**2 + 3 * paul_hours**2 >= 23, "computer_competence_3")
m.addConstr(7 * laura_hours + 3 * george_hours + 3 * paul_hours >= 23, "computer_competence_4")
m.addConstr(laura_hours**2 + 10 * george_hours**2 >= 19, "paperwork_competence_1")
m.addConstr(10 * george_hours + 9 * paul_hours >= 26, "paperwork_competence_2")
m.addConstr(laura_hours + 10 * george_hours + 9 * paul_hours >= 26, "paperwork_competence_3")
m.addConstr(7 * george_hours + paul_hours >= 22, "likelihood_to_quit_1")
m.addConstr(9 * laura_hours**2 + 7 * george_hours**2 >= 38, "likelihood_to_quit_2")
m.addConstr(9 * laura_hours + 7 * george_hours + paul_hours >= 34, "likelihood_to_quit_3")
m.addConstr(9 * laura_hours + 7 * george_hours + paul_hours >= 34, "likelihood_to_quit_4")  # Duplicate constraint, but included as specified
m.addConstr(-7 * laura_hours**2 + 8 * george_hours**2 >= 0, "custom_constraint_1")
m.addConstr(7 * laura_hours + 3 * george_hours <= 39, "computer_competence_5")
m.addConstr(7 * laura_hours**2 + 3 * george_hours**2 + 3 * paul_hours**2 <= 64, "computer_competence_6")
m.addConstr(10 * george_hours + 9 * paul_hours <= 43, "paperwork_competence_4")
m.addConstr(laura_hours + 10 * george_hours + 9 * paul_hours <= 58, "paperwork_competence_5")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Laura Hours:', laura_hours.x)
    print('George Hours:', george_hours.x)
    print('Paul Hours:', paul_hours.x)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
