
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
L = m.addVar(name='hours_worked_by_Laura', lb=-GRB.INFINITY)  # Laura can work fractional hours
G = m.addVar(name='hours_worked_by_George', lb=-GRB.INFINITY)  # George can work fractional hours
P = m.addVar(name='hours_worked_by_Paul', lb=-GRB.INFINITY)    # Paul can work fractional hours

# Objective function
m.setObjective(4*L**2 + 8*L*G + 2*G*P + 2*P**2 + 4*P, GRB.MINIMIZE)

# Constraints
# Computer competence rating constraints
m.addConstr(L >= 0)  # Implicitly handled by the variable definition

# Specific computer competence ratings for each worker
m.addConstr(7*L <= 76)
m.addConstr(3*G <= 76)
m.addConstr(3*P <= 76)

# Combined computer competence constraints
m.addConstr((L**2) + (G**2) >= 24)
m.addConstr(L + P >= 23)
m.addConstr((L**2) + (G**2) + (P**2) >= 23)
m.addConstr(L + G + P >= 23)

# Paperwork competence rating constraints
m.addConstr(G <= 82/10)  # George's paperwork constraint
m.addConstr(P <= 82/9)   # Paul's paperwork constraint

# Combined paperwork competence constraints
m.addConstr((L**2) + (G**2) >= 19)
m.addConstr(G + P >= 26)
m.addConstr(L + G + P >= 26)

# Likelihood to quit index constraints
m.addConstr(9*L <= 130)
m.addConstr(7*G <= 130)
m.addConstr(P <= 130)   # Since the likelihood for Paul is 1

# Combined likelihood to quit index constraints
m.addConstr(G + P >= 22)
m.addConstr((L**2) + (G**2) >= 38)
m.addConstr(L + G + P >= 34)

# Additional constraints
m.addConstr(-7*(L**2) + 8*(G**2) >= 0)

# Upper bound constraints on combined ratings
m.addConstr(7*L + 3*G <= 39)
m.addConstr((7*(L**2)) + (3*(G**2)) + (3*(P**2)) <= 64)
m.addConstr(10*G + 9*P <= 43)
m.addConstr(L + 10*G + 9*P <= 58)

# Solve the model
m.optimize()

