
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
L = m.addVar(lb=-gurobi.GRB.INFINITY, name="hours_worked_by_Laura")
G = m.addVar(lb=-gurobi.GRB.INFINITY, name="hours_worked_by_George")
P = m.addVar(lb=-gurobi.GRB.INFINITY, name="hours_worked_by_Paul")

# Define the objective function
m.setObjective(4*L**2 + 8*L*G + 2*G*P + 2*P**2 + 4*P, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(7*L <= 76)
m.addConstr(1*L <= 82)
m.addConstr(9*L <= 130)
m.addConstr(3*G <= 76)
m.addConstr(10*G <= 82)
m.addConstr(7*G <= 130)
m.addConstr(3*P <= 76)
m.addConstr(9*P <= 82)
m.addConstr(1*P <= 130)
m.addConstr(7*L**2 + 3*G**2 >= 24)
m.addConstr(7*L + 3*P >= 23)
m.addConstr(7*L**2 + 3*G**2 + 3*P**2 >= 23)
m.addConstr(7*L + 3*G + 3*P >= 23)
m.addConstr(1*L**2 + 10*G**2 >= 19)
m.addConstr(10*G + 9*P >= 26)
m.addConstr(1*L + 10*G + 9*P >= 26)
m.addConstr(7*G + 1*P >= 22)
m.addConstr(9*L**2 + 7*G**2 >= 38)
m.addConstr(9*L + 7*G + 1*P >= 34)
m.addConstr(9*L + 7*G + 1*P >= 34)
m.addConstr(-7*L**2 + 8*G**2 >= 0)
m.addConstr(7*L + 3*G <= 39)
m.addConstr(7*L**2 + 3*G**2 + 3*P**2 <= 64)
m.addConstr(10*G + 9*P <= 43)
m.addConstr(1*L + 10*G + 9*P <= 58)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Laura: ", L.varValue)
    print("Hours worked by George: ", G.varValue)
    print("Hours worked by Paul: ", P.varValue)
else:
    print("The model is infeasible")
