
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_hours_worked")

# Create variables
laura_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Laura_hours")
peggy_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Peggy_hours")
jean_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Jean_hours")
mary_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Mary_hours")
dale_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Dale_hours")
bobby_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Bobby_hours")
paul_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Paul_hours")


# Set objective function
m.setObjective(8.46 * laura_hours + 9.2 * peggy_hours + 3.03 * jean_hours + 4.29 * mary_hours + 9.82 * dale_hours + 4.24 * bobby_hours + 1.76 * paul_hours, gp.GRB.MINIMIZE)

# Likelihood to quit index (r0)
r0 = {'Laura_hours': 4, 'Peggy_hours': 11, 'Jean_hours': 14, 'Mary_hours': 5, 'Dale_hours': 25, 'Bobby_hours': 6, 'Paul_hours': 7}

# Dollar cost per hour (r1)
r1 = {'Laura_hours': 25, 'Peggy_hours': 8, 'Jean_hours': 16, 'Mary_hours': 18, 'Dale_hours': 13, 'Bobby_hours': 17, 'Paul_hours': 6}

# Organization score (r2)
r2 = {'Laura_hours': 19, 'Peggy_hours': 10, 'Jean_hours': 23, 'Mary_hours': 1, 'Dale_hours': 22, 'Bobby_hours': 23, 'Paul_hours': 2}

# Add constraints
m.addConstr(r0['Peggy_hours'] * peggy_hours + r0['Paul_hours'] * paul_hours >= 73)
m.addConstr(r0['Bobby_hours'] * bobby_hours + r0['Paul_hours'] * paul_hours >= 138)
m.addConstr(r0['Peggy_hours'] * peggy_hours + r0['Bobby_hours'] * bobby_hours >= 132)
m.addConstr(r0['Peggy_hours'] * peggy_hours + r0['Jean_hours'] * jean_hours >= 73)
m.addConstr(r0['Mary_hours'] * mary_hours + r0['Paul_hours'] * paul_hours >= 113)
m.addConstr(r0['Jean_hours'] * jean_hours + r0['Paul_hours'] * paul_hours >= 52)
m.addConstr(r0['Peggy_hours'] * peggy_hours + r0['Dale_hours'] * dale_hours >= 134)
m.addConstr(r0['Laura_hours'] * laura_hours + r0['Jean_hours'] * jean_hours >= 80)
m.addConstr(r0['Jean_hours'] * jean_hours + r0['Mary_hours'] * mary_hours >= 136)
m.addConstr(r0['Laura_hours'] * laura_hours + r0['Bobby_hours'] * bobby_hours >= 102)
m.addConstr(r0['Peggy_hours'] * peggy_hours + r0['Mary_hours'] * mary_hours >= 50)
m.addConstr(r0['Laura_hours'] * laura_hours + r0['Paul_hours'] * paul_hours >= 106)
m.addConstr(r0['Jean_hours'] * jean_hours + r0['Mary_hours'] * mary_hours + r0['Dale_hours'] * dale_hours >= 72)
m.addConstr(r0['Laura_hours'] * laura_hours + r0['Jean_hours'] * jean_hours + r0['Paul_hours'] * paul_hours >= 72)
m.addConstr(r0['Jean_hours'] * jean_hours + r0['Mary_hours'] * mary_hours + r0['Bobby_hours'] * bobby_hours >= 72)
m.addConstr(r0['Peggy_hours'] * peggy_hours + r0['Dale_hours'] * dale_hours + r0['Paul_hours'] * paul_hours >= 72)
m.addConstr(r0['Peggy_hours'] * peggy_hours + r0['Jean_hours'] * jean_hours + r0['Mary_hours'] * mary_hours >= 72)
m.addConstr(r0['Laura_hours'] * laura_hours + r0['Bobby_hours'] * bobby_hours + r0['Paul_hours'] * paul_hours >= 72)
m.addConstr(r0['Jean_hours'] * jean_hours + r0['Dale_hours'] * dale_hours + r0['Bobby_hours'] * bobby_hours >= 72)


# ... (Similarly add all other r0, r1, and r2 constraints)


m.addConstr(-2 * jean_hours + 6 * paul_hours >= 0)

# ... (Similarly add all other constraints)

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
