
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
hours_worked_by_Laura = m.addVar(name="hours_worked_by_Laura", lb=0)
hours_worked_by_Peggy = m.addVar(name="hours_worked_by_Peggy", lb=0, integrality=gp.GRB.INTEGER)
hours_worked_by_Jean = m.addVar(name="hours_worked_by_Jean", lb=0)
hours_worked_by_Mary = m.addVar(name="hours_worked_by_Mary", lb=0, integrality=gp.GRB.INTEGER)
hours_worked_by_Dale = m.addVar(name="hours_worked_by_Dale", lb=0, integrality=gp.GRB.INTEGER)
hours_worked_by_Bobby = m.addVar(name="hours_worked_by_Bobby", lb=0, integrality=gp.GRB.INTEGER)
hours_worked_by_Paul = m.addVar(name="hours_worked_by_Paul", lb=0, integrality=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(8.46 * hours_worked_by_Laura + 9.2 * hours_worked_by_Peggy + 3.03 * hours_worked_by_Jean + 
               4.29 * hours_worked_by_Mary + 9.82 * hours_worked_by_Dale + 4.24 * hours_worked_by_Bobby + 
               1.76 * hours_worked_by_Paul, gp.GRB.MINIMIZE)

# Add constraints
# Laura's constraints
m.addConstr(4 * hours_worked_by_Laura <= 991)
m.addConstr(25 * hours_worked_by_Laura <= 890)
m.addConstr(19 * hours_worked_by_Laura <= 785)

# Peggy's constraints
m.addConstr(11 * hours_worked_by_Peggy <= 991)
m.addConstr(8 * hours_worked_by_Peggy <= 890)
m.addConstr(10 * hours_worked_by_Peggy <= 785)

# Jean's constraints
m.addConstr(14 * hours_worked_by_Jean <= 991)
m.addConstr(16 * hours_worked_by_Jean <= 890)
m.addConstr(23 * hours_worked_by_Jean <= 785)

# Mary's constraints
m.addConstr(5 * hours_worked_by_Mary <= 991)
m.addConstr(18 * hours_worked_by_Mary <= 890)
m.addConstr(1 * hours_worked_by_Mary <= 785)

# Dale's constraints
m.addConstr(25 * hours_worked_by_Dale <= 991)
m.addConstr(13 * hours_worked_by_Dale <= 890)
m.addConstr(22 * hours_worked_by_Dale <= 785)

# Bobby's constraints
m.addConstr(6 * hours_worked_by_Bobby <= 991)
m.addConstr(17 * hours_worked_by_Bobby <= 890)
m.addConstr(23 * hours_worked_by_Bobby <= 785)

# Paul's constraints
m.addConstr(7 * hours_worked_by_Paul <= 991)
m.addConstr(6 * hours_worked_by_Paul <= 890)
m.addConstr(2 * hours_worked_by_Paul <= 785)

# Other constraints
m.addConstr(11 * hours_worked_by_Peggy + 7 * hours_worked_by_Paul >= 73)
m.addConstr(6 * hours_worked_by_Bobby + 7 * hours_worked_by_Paul >= 138)
m.addConstr(11 * hours_worked_by_Peggy + 6 * hours_worked_by_Bobby >= 132)
m.addConstr(11 * hours_worked_by_Peggy + 14 * hours_worked_by_Jean >= 73)
m.addConstr(5 * hours_worked_by_Mary + 7 * hours_worked_by_Paul >= 113)
m.addConstr(14 * hours_worked_by_Jean + 7 * hours_worked_by_Paul >= 52)
m.addConstr(11 * hours_worked_by_Peggy + 25 * hours_worked_by_Dale >= 134)
m.addConstr(4 * hours_worked_by_Laura + 14 * hours_worked_by_Jean >= 80)
m.addConstr(14 * hours_worked_by_Jean + 5 * hours_worked_by_Mary >= 136)
m.addConstr(4 * hours_worked_by_Laura + 6 * hours_worked_by_Bobby >= 102)
m.addConstr(11 * hours_worked_by_Peggy + 5 * hours_worked_by_Mary >= 50)
m.addConstr(4 * hours_worked_by_Laura + 7 * hours_worked_by_Paul >= 106)
m.addConstr(14 * hours_worked_by_Jean + 5 * hours_worked_by_Mary + 25 * hours_worked_by_Dale >= 72)
m.addConstr(4 * hours_worked_by_Laura + 14 * hours_worked_by_Jean + 7 * hours_worked_by_Paul >= 72)
m.addConstr(14 * hours_worked_by_Jean + 5 * hours_worked_by_Mary + 6 * hours_worked_by_Bobby >= 72)
m.addConstr(11 * hours_worked_by_Peggy + 25 * hours_worked_by_Dale + 7 * hours_worked_by_Paul >= 72)
m.addConstr(11 * hours_worked_by_Peggy + 14 * hours_worked_by_Jean + 5 * hours_worked_by_Mary >= 72)
m.addConstr(4 * hours_worked_by_Laura + 6 * hours_worked_by_Bobby + 7 * hours_worked_by_Paul >= 72)
m.addConstr(14 * hours_worked_by_Jean + 25 * hours_worked_by_Dale + 6 * hours_worked_by_Bobby >= 72)
m.addConstr(14 * hours_worked_by_Jean + 5 * hours_worked_by_Mary + 25 * hours_worked_by_Dale >= 111)
m.addConstr(4 * hours_worked_by_Laura + 14 * hours_worked_by_Jean + 7 * hours_worked_by_Paul >= 111)
m.addConstr(14 * hours_worked_by_Jean + 5 * hours_worked_by_Mary + 6 * hours_worked_by_Bobby >= 111)
m.addConstr(11 * hours_worked_by_Peggy + 25 * hours_worked_by_Dale + 7 * hours_worked_by_Paul >= 111)
m.addConstr(11 * hours_worked_by_Peggy + 14 * hours_worked_by_Jean + 5 * hours_worked_by_Mary >= 111)
m.addConstr(4 * hours_worked_by_Laura + 6 * hours_worked_by_Bobby + 7 * hours_worked_by_Paul >= 111)
m.addConstr(14 * hours_worked_by_Jean + 25 * hours_worked_by_Dale + 6 * hours_worked_by_Bobby >= 111)
m.addConstr(14 * hours_worked_by_Jean + 5 * hours_worked_by_Mary + 25 * hours_worked_by_Dale >= 82)
m.addConstr(4 * hours_worked_by_Laura + 14 * hours_worked_by_Jean + 7 * hours_worked_by_Paul >= 82)
m.addConstr(14 * hours_worked_by_Jean + 5 * hours_worked_by_Mary + 6 * hours_worked_by_Bobby >= 82)
m.addConstr(11 * hours_worked_by_Peggy + 25 * hours_worked_by_Dale + 7 * hours_worked_by_Paul >= 82)
m.addConstr(11 * hours_worked_by_Peggy + 14 * hours_worked_by_Jean + 5 * hours_worked_by_Mary >= 82)
m.addConstr(4 * hours_worked_by_Laura + 6 * hours_worked_by_Bobby + 7 * hours_worked_by_Paul >= 82)
m.addConstr(14 * hours_worked_by_Jean + 25 * hours_worked_by_Dale + 6 * hours_worked_by_Bobby >= 82)
m.addConstr(25 * hours_worked_by_Peggy + 8 * hours_worked_by_Dale >= 123)
m.addConstr(17 * hours_worked_by_Bobby + 6 * hours_worked_by_Paul >= 75)
m.addConstr(25 * hours_worked_by_Peggy + 25 * hours_worked_by_Bobby >= 100)
m.addConstr(18 * hours_worked_by_Mary + 6 * hours_worked_by_Paul >= 78)
m.addConstr(16 * hours_worked_by_Jean + 6 * hours_worked_by_Paul >= 62)
m.addConstr(8 * hours_worked_by_Peggy + 18 * hours_worked_by_Mary >= 49)
m.addConstr(25 * hours_worked_by_Laura + 16 * hours_worked_by_Jean >= 88)
m.addConstr(25 * hours_worked_by_Laura + 13 * hours_worked_by_Dale >= 76)
m.addConstr(18 * hours_worked_by_Mary + 17 * hours_worked_by_Bobby >= 87)
m.addConstr(13 * hours_worked_by_Dale + 18 * hours_worked_by_Mary >= 99)

# Solve the problem
m.optimize()

# Print the solution
if m.status == gp.GRB.Status.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Laura: {hours_worked_by_Laura.varValue}")
    print(f"Hours worked by Peggy: {hours_worked_by_Peggy.varValue}")
    print(f"Hours worked by Jean: {hours_worked_by_Jean.varValue}")
    print(f"Hours worked by Mary: {hours_worked_by_Mary.varValue}")
    print(f"Hours worked by Dale: {hours_worked_by_Dale.varValue}")
    print(f"Hours worked by Bobby: {hours_worked_by_Bobby.varValue}")
    print(f"Hours worked by Paul: {hours_worked_by_Paul.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
