
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
eggs = m.addVar(name="eggs", lb=0.0)
sashimi = m.addVar(name="sashimi", lb=0.0)
chicken_drumsticks = m.addVar(name="chicken_drumsticks", lb=0.0)
strips_of_bacon = m.addVar(name="strips_of_bacon", lb=0.0)
chicken_breasts = m.addVar(name="chicken_breasts", lb=0.0)

# Set objective function
m.setObjective(8.49 * eggs + 3.55 * sashimi + 1.54 * chicken_drumsticks + 9.73 * strips_of_bacon + 2.84 * chicken_breasts, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * eggs + 16 * sashimi + 2 * chicken_drumsticks + 6 * strips_of_bacon + 20 * chicken_breasts <= 553, "r0") # dollar cost
m.addConstr(1 * eggs + 1 * sashimi + 17 * chicken_drumsticks + 6 * strips_of_bacon + 8 * chicken_breasts <= 246, "r1") # calcium

m.addConstr(16 * sashimi + 6 * strips_of_bacon + 20 * chicken_breasts >= 71, "c1")
m.addConstr(6 * strips_of_bacon + 8 * chicken_breasts >= 25, "c2")
m.addConstr(17 * chicken_drumsticks + 6 * strips_of_bacon >= 17, "c3")
m.addConstr(4 * eggs - 7 * chicken_drumsticks + 8 * strips_of_bacon >= 0, "c4")
m.addConstr(6 * strips_of_bacon + 20 * chicken_breasts <= 311, "c5")
m.addConstr(5 * eggs + 16 * sashimi + 6 * strips_of_bacon <= 393, "c6")
m.addConstr(5 * eggs + 16 * sashimi + 20 * chicken_breasts <= 208, "c7")
m.addConstr(16 * sashimi + 2 * chicken_drumsticks + 20 * chicken_breasts <= 550, "c8")
m.addConstr(16 * sashimi + 2 * chicken_drumsticks + 6 * strips_of_bacon <= 301, "c9")
m.addConstr(5 * eggs + 16 * sashimi + 2 * chicken_drumsticks + 6 * strips_of_bacon + 20 * chicken_breasts <= 301, "c10")
m.addConstr(1 * eggs + 17 * chicken_drumsticks <= 95, "c11")
m.addConstr(1 * eggs + 8 * chicken_breasts <= 186, "c12")
m.addConstr(1 * sashimi + 8 * chicken_breasts <= 81, "c13")
m.addConstr(1 * sashimi + 17 * chicken_drumsticks <= 199, "c14")
m.addConstr(1 * eggs + 1 * sashimi <= 214, "c15")
m.addConstr(6 * strips_of_bacon + 8 * chicken_breasts <= 200, "c16")
m.addConstr(1 * sashimi + 6 * strips_of_bacon <= 73, "c17")
m.addConstr(1 * eggs + 1 * sashimi + 8 * chicken_breasts <= 129, "c18")
m.addConstr(1 * eggs + 6 * strips_of_bacon + 8 * chicken_breasts <= 217, "c19")
m.addConstr(1 * sashimi + 6 * strips_of_bacon + 8 * chicken_breasts <= 68, "c20")
m.addConstr(1 * eggs + 1 * sashimi + 17 * chicken_drumsticks <= 243, "c21")
m.addConstr(1 * eggs + 1 * sashimi + 17 * chicken_drumsticks + 6 * strips_of_bacon + 8 * chicken_breasts <= 243, "c22")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

