
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
hot_dogs = m.addVar(vtype=GRB.INTEGER, name="hot_dogs")
cantaloupes = m.addVar(vtype=GRB.CONTINUOUS, name="cantaloupes")
cornichons = m.addVar(vtype=GRB.INTEGER, name="cornichons")
fruit_salads = m.addVar(vtype=GRB.INTEGER, name="fruit_salads")
ravioli = m.addVar(vtype=GRB.CONTINUOUS, name="ravioli")

# Set objective function
m.setObjective(
    6.2 * hot_dogs**2
    + 7.63 * hot_dogs * cantaloupes
    + 9.51 * hot_dogs * ravioli
    + 2.02 * cantaloupes**2
    + 2.71 * cantaloupes * cornichons
    + 5.94 * cantaloupes * fruit_salads
    + 7.99 * cantaloupes * ravioli
    + 9.86 * cornichons**2
    + 2.98 * cornichons * fruit_salads
    + 4.51 * fruit_salads**2
    + 1.45 * hot_dogs
    + 2.82 * cantaloupes
    + 1.43 * cornichons
    + 6.2 * fruit_salads
    + 7.91 * ravioli,
    GRB.MAXIMIZE,
)

# Add constraints
m.addConstr(1.38 * cornichons + 1.97 * ravioli >= 32)
m.addConstr(1.64 * hot_dogs + 1.98 * fruit_salads >= 40)
m.addConstr(1.98 * fruit_salads + 1.97 * ravioli >= 27)
m.addConstr(1.64 * hot_dogs + 1.38 * cornichons >= 46)
m.addConstr(1.64 * hot_dogs + 1.38 * cornichons + 1.97 * ravioli >= 49)
m.addConstr(1.95 * cantaloupes + 1.98 * fruit_salads + 1.97 * ravioli >= 49)
m.addConstr(1.95 * cantaloupes**2 + 1.38 * cornichons**2 + 1.98 * fruit_salads**2 >= 49)
m.addConstr(1.64 * hot_dogs**2 + 1.38 * cornichons**2 + 1.98 * fruit_salads**2 >= 49)
m.addConstr(1.64 * hot_dogs + 1.95 * cantaloupes + 1.97 * ravioli >= 49)
m.addConstr(1.64 * hot_dogs + 1.95 * cantaloupes + 1.98 * fruit_salads >= 49)
m.addConstr(1.64 * hot_dogs + 1.98 * fruit_salads + 1.97 * ravioli >= 49)
m.addConstr(1.64 * hot_dogs**2 + 1.38 * cornichons**2 + 1.97 * ravioli**2 >= 36)
m.addConstr(1.95 * cantaloupes + 1.98 * fruit_salads + 1.97 * ravioli >= 36)
m.addConstr(1.95 * cantaloupes**2 + 1.38 * cornichons**2 + 1.98 * fruit_salads**2 >= 36)
m.addConstr(1.64 * hot_dogs + 1.38 * cornichons + 1.98 * fruit_salads >= 36)
m.addConstr(1.64 * hot_dogs + 1.95 * cantaloupes + 1.97 * ravioli >= 36)
m.addConstr(1.64 * hot_dogs**2 + 1.95 * cantaloupes**2 + 1.98 * fruit_salads**2 >= 36)
m.addConstr(1.64 * hot_dogs + 1.98 * fruit_salads + 1.97 * ravioli >= 36)

# ... (rest of the constraints, similarly structured)

m.addConstr(1.64 * hot_dogs + 1.95 * cantaloupes + 1.38 * cornichons + 1.98 * fruit_salads + 1.97 * ravioli <= 191, "total_fat")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hot dogs: {hot_dogs.x}")
    print(f"Cantaloupes: {cantaloupes.x}")
    print(f"Cornichons: {cornichons.x}")
    print(f"Fruit salads: {fruit_salads.x}")
    print(f"Ravioli: {ravioli.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

