
import gurobipy as gp

# Create a new model
m = gp.Model("power_optimization")

# Create variables
alerts = m.addVar(vtype=gp.GRB.INTEGER, name="alerts")
engineers = m.addVar(vtype=gp.GRB.INTEGER, name="engineers")
admins = m.addVar(vtype=gp.GRB.INTEGER, name="admins")

# Set objective function
m.setObjective(3 * alerts + 4 * engineers + 3 * admins, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(15 * alerts + 1 * engineers + 19 * admins <= 234, "total_power") # Total power consumption constraint
m.addConstr(1 * engineers + 19 * admins >= 41, "eng_admin_power") # Power consumption of engineers and admins
m.addConstr(15 * alerts + 1 * engineers >= 53, "alerts_eng_power") # Power consumption of alerts and engineers
m.addConstr(15 * alerts + 1 * engineers + 19 * admins >= 40, "min_total_power") # Minimum total power consumption
m.addConstr(-2 * engineers + 10 * admins >= 0, "eng_admin_ratio") # Ratio constraint

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Automatic Alerts: {alerts.x}")
    print(f"  Security Engineers: {engineers.x}")
    print(f"  Network Administrators: {admins.x}")
    print(f"  Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

