
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(vtype=GRB.INTEGER, name="automatic_alerts")
x1 = m.addVar(vtype=GRB.INTEGER, name="security_engineers")
x2 = m.addVar(vtype=GRB.INTEGER, name="network_administrators")

# Objective function
m.setObjective(3*x0 + 4*x1 + 3*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(15*x0 + x1 + 19*x2 <= 234, "power_consumption_limit")
m.addConstr(x1 + 19*x2 >= 41, "min_power_security_network")
m.addConstr(15*x0 + x1 >= 53, "min_power_alerts_security")
m.addConstr(15*x0 + x1 + 19*x2 >= 40, "total_min_power_consumption")
m.addConstr(-2*x1 + 10*x2 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Automatic Alerts: {x0.x}")
    print(f"Security Engineers: {x1.x}")
    print(f"Network Administrators: {x2.x}")
else:
    print("No optimal solution found.")
