
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
automatic_alerts = m.addVar(name="automatic_alerts", integer=True)
security_engineers = m.addVar(name="security_engineers", integer=True)
network_administrators = m.addVar(name="network_administrators", integer=True)

# Objective function
m.setObjective(3 * automatic_alerts + 4 * security_engineers + 3 * network_administrators, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(automatic_alerts * 15 + security_engineers * 1 + network_administrators * 19 <= 234, name="power_consumption_limit")
m.addConstr(security_engineers * 1 + network_administrators * 19 >= 41, name="min_security_engineers_network_administrators_power")
m.addConstr(automatic_alerts * 15 + security_engineers * 1 >= 53, name="min_automatic_alerts_security_engineers_power")
m.addConstr(automatic_alerts * 15 + security_engineers * 1 + network_administrators * 19 >= 40, name="min_total_power_consumption")
m.addConstr(-2 * security_engineers + 10 * network_administrators >= 0, name="security_engineers_network_administrators_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Automatic Alerts: {automatic_alerts.varValue}")
    print(f"Security Engineers: {security_engineers.varValue}")
    print(f"Network Administrators: {network_administrators.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
