
from gurobipy import Model, GRB

# Create a new model
model = Model("minimize_cost")

# Create variables
jean_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="jean_hours")
mary_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mary_hours")

# Set objective function
model.setObjective(8.91 * jean_hours * mary_hours + 3.63 * jean_hours + 2.92 * mary_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(14 * jean_hours + 14 * mary_hours >= 39, "dollar_cost_min")
model.addConstr(11 * jean_hours + 7 * mary_hours >= 61, "likelihood_min")
model.addConstr(10 * jean_hours * jean_hours - 2 * mary_hours * mary_hours >= 0, "quadratic_constraint")
model.addConstr(14 * jean_hours * jean_hours + 14 * mary_hours * mary_hours <= 87, "dollar_cost_squared_max")
model.addConstr(11 * jean_hours + 7 * mary_hours <= 77, "likelihood_max")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal objective value: {model.objVal}")
    print(f"Hours worked by Jean: {jean_hours.x}")
    print(f"Hours worked by Mary: {mary_hours.x}")

